/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.completion;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class OpenAiChatCompletionServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
OpenAiRateLimitServiceSettings {
    public static final String NAME = "openai_completion_service_settings";
    public static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(500L);
    private final String modelId;
    private final URI uri;
    private final String organizationId;
    private final Integer maxInputTokens;
    private final RateLimitSettings rateLimitSettings;

    public static OpenAiChatCompletionServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        String organizationId = ServiceUtils.extractOptionalString(map, "organization_id", "service_settings", validationException);
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        URI uri = ServiceUtils.convertToUri(url, "url", "service_settings", validationException);
        Integer maxInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "openai", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new OpenAiChatCompletionServiceSettings(modelId, uri, organizationId, maxInputTokens, rateLimitSettings);
    }

    public OpenAiChatCompletionServiceSettings(String modelId, @Nullable URI uri, @Nullable String organizationId, @Nullable Integer maxInputTokens, @Nullable RateLimitSettings ratelimitSettings) {
        this.modelId = modelId;
        this.uri = uri;
        this.organizationId = organizationId;
        this.maxInputTokens = maxInputTokens;
        this.rateLimitSettings = Objects.requireNonNullElse(ratelimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    OpenAiChatCompletionServiceSettings(String modelId, @Nullable String uri, @Nullable String organizationId, @Nullable Integer maxInputTokens, @Nullable RateLimitSettings rateLimitSettings) {
        this(modelId, ServiceUtils.createOptionalUri(uri), organizationId, maxInputTokens, rateLimitSettings);
    }

    public OpenAiChatCompletionServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.uri = ServiceUtils.createOptionalUri(in.readOptionalString());
        this.organizationId = in.readOptionalString();
        this.maxInputTokens = in.readOptionalVInt();
        this.rateLimitSettings = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0) ? new RateLimitSettings(in) : DEFAULT_RATE_LIMIT_SETTINGS;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String organizationId() {
        return this.organizationId;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        if (this.uri != null) {
            builder.field("url", this.uri.toString());
        }
        if (this.organizationId != null) {
            builder.field("organization_id", this.organizationId);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_14_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeOptionalString(this.uri != null ? this.uri.toString() : null);
        out.writeOptionalString(this.organizationId);
        out.writeOptionalVInt(this.maxInputTokens);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_15_0)) {
            this.rateLimitSettings.writeTo(out);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OpenAiChatCompletionServiceSettings that = (OpenAiChatCompletionServiceSettings)object;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.uri, that.uri) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.uri, this.organizationId, this.maxInputTokens, this.rateLimitSettings);
    }
}

