/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.Map;
import org.elasticsearch.xpack.profiling.action.CloudProviders;
import org.elasticsearch.xpack.profiling.action.CostCalculator;
import org.elasticsearch.xpack.profiling.action.HostMetadata;

final class CO2Calculator {
    private static final double DEFAULT_CO2_TONS_PER_KWH = 3.79069E-4;
    private static final double DEFAULT_KILOWATTS_PER_CORE_X86 = 0.007;
    private static final double DEFAULT_KILOWATTS_PER_CORE_ARM64 = 0.0028;
    private static final double DEFAULT_KILOWATTS_PER_CORE = 0.007;
    private static final double DEFAULT_DATACENTER_PUE = 1.7;
    private final Map<String, HostMetadata> hostMetadata;
    private final double samplingDurationInSeconds;
    private final double customCO2PerKWH;
    private final double customDatacenterPUE;
    private final double customKilowattsPerCoreX86;
    private final double customKilowattsPerCoreARM64;

    CO2Calculator(Map<String, HostMetadata> hostMetadata, double samplingDurationInSeconds, Double customCO2PerKWH, Double customDatacenterPUE, Double customPerCoreWattX86, Double customPerCoreWattARM64) {
        this.hostMetadata = hostMetadata;
        this.samplingDurationInSeconds = samplingDurationInSeconds > 0.0 ? samplingDurationInSeconds : 1.0;
        this.customCO2PerKWH = customCO2PerKWH == null ? 3.79069E-4 : customCO2PerKWH;
        this.customDatacenterPUE = customDatacenterPUE == null ? 1.7 : customDatacenterPUE;
        this.customKilowattsPerCoreX86 = customPerCoreWattX86 == null ? 0.007 : customPerCoreWattX86 / 1000.0;
        this.customKilowattsPerCoreARM64 = customPerCoreWattARM64 == null ? 0.0028 : customPerCoreWattARM64 / 1000.0;
    }

    public double getAnnualCO2Tons(String hostID, long samples, double samplingFrequency) {
        double annualCoreHours = CostCalculator.annualCoreHours(this.samplingDurationInSeconds, samples, samplingFrequency);
        HostMetadata host = this.hostMetadata.get(hostID);
        if (host == null) {
            return 0.007 * this.customCO2PerKWH * annualCoreHours * this.customDatacenterPUE;
        }
        return this.getKiloWattsPerCore(host) * this.getCO2TonsPerKWH(host) * annualCoreHours * this.getDatacenterPUE(host);
    }

    private double getKiloWattsPerCore(HostMetadata host) {
        return switch (host.hostArchitecture) {
            case "arm64", "aarch64" -> this.customKilowattsPerCoreARM64;
            case "amd64", "x86_64" -> this.customKilowattsPerCoreX86;
            default -> 0.007;
        };
    }

    private double getCO2TonsPerKWH(HostMetadata host) {
        return CloudProviders.getCO2TonsPerKWHOrDefault(host.instanceType.provider, host.instanceType.region, this.customCO2PerKWH);
    }

    private double getDatacenterPUE(HostMetadata host) {
        return CloudProviders.getPUEOrDefault(host.instanceType.provider, this.customDatacenterPUE);
    }
}

