/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.blobcache.CachePopulationSource;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class BlobCacheMetrics {
    private static final Logger logger = LogManager.getLogger(BlobCacheMetrics.class);
    private static final double BYTES_PER_NANOSECONDS_TO_MEBIBYTES_PER_SECOND = 953.67431640625;
    public static final String CACHE_POPULATION_REASON_ATTRIBUTE_KEY = "reason";
    public static final String CACHE_POPULATION_SOURCE_ATTRIBUTE_KEY = "source";
    public static final String LUCENE_FILE_EXTENSION_ATTRIBUTE_KEY = "file_extension";
    public static final String ES_EXECUTOR_ATTRIBUTE_KEY = "executor";
    public static final String NON_LUCENE_EXTENSION_TO_RECORD = "other";
    public static final String NON_ES_EXECUTOR_TO_RECORD = "other";
    public static final String BLOB_CACHE_COUNT_OF_EVICTED_REGIONS_TOTAL = "es.blob_cache.count_of_evicted_regions.total";
    public static final String SEARCH_ORIGIN_REMOTE_STORAGE_DOWNLOAD_TOOK_TIME = "es.blob_cache.search_origin.download_took_time.total";
    private final LongCounter cacheMissCounter;
    private final LongCounter evictedCountNonZeroFrequency;
    private final LongCounter totalEvictedCount;
    private final LongHistogram cacheMissLoadTimes;
    private final DoubleHistogram cachePopulationThroughput;
    private final LongCounter cachePopulationBytes;
    private final LongCounter cachePopulationTime;
    private final LongAdder missCount = new LongAdder();
    private final LongAdder readCount = new LongAdder();
    private final LongCounter epochChanges;
    private final LongHistogram searchOriginDownloadTime;
    public static final BlobCacheMetrics NOOP = new BlobCacheMetrics(TelemetryProvider.NOOP.getMeterRegistry());

    public BlobCacheMetrics(MeterRegistry meterRegistry) {
        this(meterRegistry.registerLongCounter("es.blob_cache.miss_that_triggered_read.total", "The number of times there was a cache miss that triggered a read from the blob store", "count"), meterRegistry.registerLongCounter("es.blob_cache.count_of_evicted_used_regions.total", "The number of times a cache entry was evicted where the frequency was not zero", "entries"), meterRegistry.registerLongCounter(BLOB_CACHE_COUNT_OF_EVICTED_REGIONS_TOTAL, "The number of times a cache entry was evicted, irrespective of the frequency", "entries"), meterRegistry.registerLongHistogram("es.blob_cache.cache_miss_load_times.histogram", "The time in milliseconds for populating entries in the blob store resulting from a cache miss, expressed as a histogram.", "ms"), meterRegistry.registerDoubleHistogram("es.blob_cache.population.throughput.histogram", "The throughput observed when populating the cache", "MiB/second"), meterRegistry.registerLongCounter("es.blob_cache.population.bytes.total", "The number of bytes that have been copied into the cache", "bytes"), meterRegistry.registerLongCounter("es.blob_cache.population.time.total", "The time spent copying data into the cache", "milliseconds"), meterRegistry.registerLongCounter("es.blob_cache.epoch.total", "The epoch changes of the LFU cache", "count"), meterRegistry.registerLongHistogram(SEARCH_ORIGIN_REMOTE_STORAGE_DOWNLOAD_TOOK_TIME, "The distribution of time in millis taken to download data from remote storage for search requests", "milliseconds"));
        meterRegistry.registerLongGauge("es.blob_cache.read.total", "The number of cache reads (warming not included)", "count", () -> new LongWithAttributes(this.readCount.longValue()));
        meterRegistry.registerLongGauge("es.blob_cache.miss.total", "The number of cache misses (warming not included)", "count", () -> new LongWithAttributes(this.missCount.longValue()));
        meterRegistry.registerDoubleGauge("es.blob_cache.miss.ratio", "The fraction of cache reads that missed data (warming not included)", "fraction", () -> new DoubleWithAttributes(Math.min((double)this.missCount.longValue() / (double)Math.max(this.readCount.longValue(), 1L), 1.0)));
    }

    BlobCacheMetrics(LongCounter cacheMissCounter, LongCounter evictedCountNonZeroFrequency, LongCounter totalEvictedCount, LongHistogram cacheMissLoadTimes, DoubleHistogram cachePopulationThroughput, LongCounter cachePopulationBytes, LongCounter cachePopulationTime, LongCounter epochChanges, LongHistogram searchOriginDownloadTime) {
        this.cacheMissCounter = cacheMissCounter;
        this.evictedCountNonZeroFrequency = evictedCountNonZeroFrequency;
        this.totalEvictedCount = totalEvictedCount;
        this.cacheMissLoadTimes = cacheMissLoadTimes;
        this.cachePopulationThroughput = cachePopulationThroughput;
        this.cachePopulationBytes = cachePopulationBytes;
        this.cachePopulationTime = cachePopulationTime;
        this.epochChanges = epochChanges;
        this.searchOriginDownloadTime = searchOriginDownloadTime;
    }

    public LongCounter getCacheMissCounter() {
        return this.cacheMissCounter;
    }

    public LongCounter getEvictedCountNonZeroFrequency() {
        return this.evictedCountNonZeroFrequency;
    }

    public LongCounter getTotalEvictedCount() {
        return this.totalEvictedCount;
    }

    public LongHistogram getCacheMissLoadTimes() {
        return this.cacheMissLoadTimes;
    }

    public LongHistogram getSearchOriginDownloadTime() {
        return this.searchOriginDownloadTime;
    }

    public void recordCachePopulationMetrics(String fileName, int bytesCopied, long copyTimeNanos, CachePopulationReason cachePopulationReason, CachePopulationSource cachePopulationSource) {
        LuceneFilesExtensions luceneFilesExtensions = LuceneFilesExtensions.fromFile((String)fileName);
        String luceneFileExt = luceneFilesExtensions != null ? luceneFilesExtensions.getExtension() : "other";
        String executorName = EsExecutors.executorName((Thread)Thread.currentThread());
        Map<String, String> metricAttributes = Map.of(CACHE_POPULATION_REASON_ATTRIBUTE_KEY, cachePopulationReason.name(), CACHE_POPULATION_SOURCE_ATTRIBUTE_KEY, cachePopulationSource.name(), LUCENE_FILE_EXTENSION_ATTRIBUTE_KEY, luceneFileExt, ES_EXECUTOR_ATTRIBUTE_KEY, executorName != null ? executorName : "other");
        assert (bytesCopied > 0) : "We shouldn't be recording zero-sized copies";
        this.cachePopulationBytes.incrementBy((long)bytesCopied, metricAttributes);
        if (copyTimeNanos > 0L) {
            this.cachePopulationThroughput.record(this.toMebibytesPerSecond(bytesCopied, copyTimeNanos), metricAttributes);
            this.cachePopulationTime.incrementBy(TimeUnit.NANOSECONDS.toMillis(copyTimeNanos), metricAttributes);
        } else {
            logger.warn("Zero-time copy being reported, ignoring");
        }
    }

    public void recordEpochChange() {
        this.epochChanges.increment();
    }

    public void recordRead() {
        this.readCount.increment();
    }

    public void recordMiss() {
        this.missCount.increment();
    }

    public long readCount() {
        return this.readCount.sum();
    }

    public long missCount() {
        return this.missCount.sum();
    }

    private double toMebibytesPerSecond(int numberOfBytes, long timeInNanoseconds) {
        return (double)numberOfBytes / (double)timeInNanoseconds * 953.67431640625;
    }

    public static enum CachePopulationReason {
        Warming,
        OnlinePrewarming,
        CacheMiss,
        PreFetchingNewCommit;

    }
}

