/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.datastreams.DataStreamsPlugin;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DynamicTemplate;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.PassThroughObjectMapper;

public class DataStreamIndexSettingsProvider
implements IndexSettingProvider {
    static final DateFormatter FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
    private final CheckedFunction<IndexMetadata, MapperService, IOException> mapperServiceFactory;

    DataStreamIndexSettingsProvider(CheckedFunction<IndexMetadata, MapperService, IOException> mapperServiceFactory) {
        this.mapperServiceFactory = mapperServiceFactory;
    }

    public void provideAdditionalSettings(String indexName, @Nullable String dataStreamName, @Nullable IndexMode templateIndexMode, ProjectMetadata projectMetadata, Instant resolvedAt, Settings indexTemplateAndCreateRequestSettings, List<CompressedXContent> combinedTemplateMappings, IndexVersion indexVersion, Settings.Builder additionalSettings) {
        if (dataStreamName != null) {
            boolean migrating;
            DataStream dataStream = (DataStream)projectMetadata.dataStreams().get(dataStreamName);
            boolean isMigratingToTimeSeries = templateIndexMode == IndexMode.TIME_SERIES;
            boolean bl = migrating = dataStream != null && (dataStream.getIndexMode() == null || dataStream.getIndexMode() == IndexMode.STANDARD) && isMigratingToTimeSeries;
            Object indexMode = migrating ? IndexMode.TIME_SERIES : (dataStream != null ? (isMigratingToTimeSeries ? dataStream.getIndexMode() : null) : (isMigratingToTimeSeries ? IndexMode.TIME_SERIES : null));
            if (indexMode != null && indexMode == IndexMode.TIME_SERIES) {
                Instant end;
                Instant start;
                TimeValue lookAheadTime = DataStreamsPlugin.getLookAheadTime(indexTemplateAndCreateRequestSettings);
                TimeValue lookBackTime = (TimeValue)DataStreamsPlugin.LOOK_BACK_TIME.get(indexTemplateAndCreateRequestSettings);
                if (dataStream == null || migrating) {
                    start = DataStream.getCanonicalTimestampBound((Instant)resolvedAt.minusMillis(lookBackTime.getMillis()));
                    end = DataStream.getCanonicalTimestampBound((Instant)resolvedAt.plusMillis(lookAheadTime.getMillis()));
                } else {
                    IndexMetadata currentLatestBackingIndex = projectMetadata.index(dataStream.getWriteIndex());
                    if (!currentLatestBackingIndex.getSettings().hasValue(IndexSettings.TIME_SERIES_END_TIME.getKey())) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "backing index [%s] in tsdb mode doesn't have the [%s] index setting", currentLatestBackingIndex.getIndex().getName(), IndexSettings.TIME_SERIES_END_TIME.getKey()));
                    }
                    start = (Instant)IndexSettings.TIME_SERIES_END_TIME.get(currentLatestBackingIndex.getSettings());
                    end = start.isAfter(resolvedAt) ? DataStream.getCanonicalTimestampBound((Instant)start.plusMillis(lookAheadTime.getMillis())) : DataStream.getCanonicalTimestampBound((Instant)resolvedAt.plusMillis(lookAheadTime.getMillis()));
                }
                assert (start.isBefore(end)) : "data stream backing index's start time is not before end time";
                additionalSettings.put(IndexSettings.TIME_SERIES_START_TIME.getKey(), FORMATTER.format((TemporalAccessor)start));
                additionalSettings.put(IndexSettings.TIME_SERIES_END_TIME.getKey(), FORMATTER.format((TemporalAccessor)end));
                if (!indexTemplateAndCreateRequestSettings.hasValue(IndexMetadata.INDEX_ROUTING_PATH.getKey()) && !combinedTemplateMappings.isEmpty()) {
                    ArrayList<String> dimensions = new ArrayList<String>();
                    boolean matchesAllDimensions = this.findDimensionFields(indexName, indexTemplateAndCreateRequestSettings, combinedTemplateMappings, dimensions);
                    if (!dimensions.isEmpty()) {
                        if (matchesAllDimensions && ((Boolean)IndexMetadata.INDEX_DIMENSIONS_TSID_STRATEGY_ENABLED.get(indexTemplateAndCreateRequestSettings)).booleanValue() && indexVersion.onOrAfter((VersionId)IndexVersions.TSID_CREATED_DURING_ROUTING)) {
                            additionalSettings.putList(IndexMetadata.INDEX_DIMENSIONS.getKey(), dimensions);
                        } else {
                            additionalSettings.putList(IndexMetadata.INDEX_ROUTING_PATH.getKey(), dimensions);
                        }
                    }
                }
            }
        }
    }

    public void onUpdateMappings(IndexMetadata indexMetadata, DocumentMapper documentMapper, Settings.Builder additionalSettings) {
        boolean hasChanges;
        List indexDimensions = indexMetadata.getTimeSeriesDimensions();
        if (indexDimensions.isEmpty()) {
            return;
        }
        assert (indexMetadata.getIndexMode() == IndexMode.TIME_SERIES);
        ArrayList<String> newIndexDimensions = new ArrayList<String>(indexDimensions.size());
        boolean matchesAllDimensions = DataStreamIndexSettingsProvider.findDimensionFields(newIndexDimensions, documentMapper);
        boolean bl = hasChanges = indexDimensions.size() != newIndexDimensions.size() && !new HashSet(indexDimensions).equals(new HashSet<String>(newIndexDimensions));
        if (!matchesAllDimensions) {
            throw new IllegalArgumentException("Cannot add dynamic templates that define dimension fields on an existing index with " + IndexMetadata.INDEX_DIMENSIONS.getKey() + ". Please change the index template and roll over the data stream instead of modifying the mappings of the backing indices.");
        }
        if (hasChanges) {
            additionalSettings.putList(IndexMetadata.INDEX_DIMENSIONS.getKey(), newIndexDimensions);
        }
    }

    private boolean findDimensionFields(String indexName, Settings allSettings, List<CompressedXContent> combinedTemplateMappings, List<String> dimensions) {
        boolean bl;
        block8: {
            IndexMetadata.Builder tmpIndexMetadata = IndexMetadata.builder((String)indexName);
            int dummyPartitionSize = (Integer)IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(allSettings);
            int dummyShards = allSettings.getAsInt("index.number_of_shards", Integer.valueOf(dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1));
            int shardReplicas = allSettings.getAsInt("index.number_of_replicas", Integer.valueOf(0));
            Settings finalResolvedSettings = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).put(allSettings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", shardReplicas).put("index.uuid", UUIDs.randomBase64UUID()).put(IndexSettings.MODE.getKey(), (Enum)IndexMode.TIME_SERIES).putList(IndexMetadata.INDEX_ROUTING_PATH.getKey(), List.of("path")).build();
            tmpIndexMetadata.settings(finalResolvedSettings);
            MapperService mapperService = (MapperService)this.mapperServiceFactory.apply((Object)tmpIndexMetadata.build());
            try {
                mapperService.merge("_doc", combinedTemplateMappings, MapperService.MergeReason.INDEX_TEMPLATE);
                DocumentMapper documentMapper = mapperService.documentMapper();
                bl = DataStreamIndexSettingsProvider.findDimensionFields(dimensions, documentMapper);
                if (mapperService == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (mapperService != null) {
                        try {
                            mapperService.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            mapperService.close();
        }
        return bl;
    }

    private static boolean findDimensionFields(List<String> dimensions, DocumentMapper documentMapper) {
        for (ObjectMapper objectMapper : documentMapper.mappers().objectMappers().values()) {
            PassThroughObjectMapper passThroughObjectMapper;
            if (!(objectMapper instanceof PassThroughObjectMapper) || !(passThroughObjectMapper = (PassThroughObjectMapper)objectMapper).containsDimensions()) continue;
            dimensions.add(passThroughObjectMapper.fullPath() + ".*");
        }
        boolean matchesAllDimensions = true;
        for (DynamicTemplate template : documentMapper.mapping().getRoot().dynamicTemplates()) {
            if (!template.isTimeSeriesDimension()) continue;
            matchesAllDimensions = false;
            if (template.pathMatch().isEmpty()) continue;
            dimensions.addAll(template.pathMatch());
        }
        for (Mapper fieldMapper : documentMapper.mappers().fieldMappers()) {
            DataStreamIndexSettingsProvider.extractPath(dimensions, fieldMapper);
        }
        return matchesAllDimensions;
    }

    private static void extractPath(List<String> dimensions, Mapper mapper) {
        String path;
        FieldMapper fieldMapper;
        if (mapper instanceof FieldMapper && (fieldMapper = (FieldMapper)mapper).fieldType().isDimension() && !Regex.simpleMatch(dimensions, (String)(path = mapper.fullPath()))) {
            dimensions.add(path);
        }
    }
}

