/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.topn.SortableTopNEncoder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;

final class UTF8TopNEncoder
extends SortableTopNEncoder {
    private static final int CONTINUATION_BYTE = 128;
    static final byte TERMINATOR = 0;
    static final int[] utf8CodeLength;

    UTF8TopNEncoder() {
    }

    @Override
    public int encodeBytesRef(BytesRef value, BreakingBytesRefBuilder bytesRefBuilder) {
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            byte b = value.bytes[i];
            if ((b & 0x80) == 0) {
                b = (byte)(b + 1);
            }
            bytesRefBuilder.append(b);
        }
        bytesRefBuilder.append((byte)0);
        return value.length + 1;
    }

    @Override
    public BytesRef decodeBytesRef(BytesRef bytes, BytesRef scratch) {
        scratch.bytes = bytes.bytes;
        scratch.offset = bytes.offset;
        scratch.length = 0;
        int i = bytes.offset;
        block7: while (true) {
            int leadByte = bytes.bytes[i] & 0xFF;
            int numBytes = utf8CodeLength[leadByte];
            switch (numBytes) {
                case 0: {
                    break block7;
                }
                case 1: {
                    int n = i++;
                    bytes.bytes[n] = (byte)(bytes.bytes[n] - 1);
                    break;
                }
                case 2: {
                    i += 2;
                    break;
                }
                case 3: {
                    i += 3;
                    break;
                }
                case 4: {
                    i += 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid UTF8 header byte: 0x" + Integer.toHexString(leadByte));
                }
            }
        }
        scratch.length = i - bytes.offset;
        bytes.offset = i + 1;
        bytes.length -= scratch.length + 1;
        return scratch;
    }

    @Override
    public TopNEncoder toSortable() {
        return this;
    }

    @Override
    public TopNEncoder toUnsortable() {
        return this;
    }

    public String toString() {
        return "UTF8TopNEncoder";
    }

    static {
        int v = Integer.MIN_VALUE;
        utf8CodeLength = Arrays.stream(new int[][]{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, v, v, v, v, v, v, v, v, v, v, v, v, v, v, v}, {v, v, v, v, v, v, v, v, v, v, v, v, v, v, v, v}, {v, v, v, v, v, v, v, v, v, v, v, v, v, v, v, v}, {v, v, v, v, v, v, v, v, v, v, v, v, v, v, v, v}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {4, 4, 4, 4, 4, 4, 4, 4}}).flatMapToInt(Arrays::stream).toArray();
    }
}

