/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.compute.operator.DriverSleeps;
import org.elasticsearch.compute.operator.OperatorStatus;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;

public record DriverProfile(String description, String clusterName, String nodeName, long startMillis, long stopMillis, long tookNanos, long cpuNanos, long iterations, List<OperatorStatus> operators, DriverSleeps sleeps) implements Writeable,
ChunkedToXContentObject
{
    private static final TransportVersion ESQL_DRIVER_NODE_DESCRIPTION = TransportVersion.fromName((String)"esql_driver_node_description");
    private static final TransportVersion ESQL_DRIVER_TASK_DESCRIPTION = TransportVersion.fromName((String)"esql_driver_task_description");

    public static DriverProfile readFrom(StreamInput in) throws IOException {
        return new DriverProfile(in.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION) ? in.readString() : "", in.getTransportVersion().supports(ESQL_DRIVER_NODE_DESCRIPTION) ? in.readString() : "", in.getTransportVersion().supports(ESQL_DRIVER_NODE_DESCRIPTION) ? in.readString() : "", in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readCollectionAsImmutableList(OperatorStatus::readFrom), DriverSleeps.read(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_DRIVER_TASK_DESCRIPTION)) {
            out.writeString(this.description);
        }
        if (out.getTransportVersion().supports(ESQL_DRIVER_NODE_DESCRIPTION)) {
            out.writeString(this.clusterName);
            out.writeString(this.nodeName);
        }
        out.writeVLong(this.startMillis);
        out.writeVLong(this.stopMillis);
        out.writeVLong(this.tookNanos);
        out.writeVLong(this.cpuNanos);
        out.writeVLong(this.iterations);
        out.writeCollection(this.operators);
        this.sleeps.writeTo(out);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), Iterators.single((b, p) -> {
            b.field("description", this.description);
            b.field("cluster_name", this.clusterName);
            b.field("node_name", this.nodeName);
            b.timestampFieldsFromUnixEpochMillis("start_millis", "start", this.startMillis);
            b.timestampFieldsFromUnixEpochMillis("stop_millis", "stop", this.stopMillis);
            b.field("took_nanos", this.tookNanos);
            if (b.humanReadable()) {
                b.field("took_time", (Object)TimeValue.timeValueNanos((long)this.tookNanos));
            }
            b.field("cpu_nanos", this.cpuNanos);
            if (b.humanReadable()) {
                b.field("cpu_time", (Object)TimeValue.timeValueNanos((long)this.cpuNanos));
            }
            b.field("documents_found", this.operators.stream().mapToLong(OperatorStatus::documentsFound).sum());
            b.field("values_loaded", this.operators.stream().mapToLong(OperatorStatus::valuesLoaded).sum());
            b.field("iterations", this.iterations);
            return b;
        }), ChunkedToXContentHelper.array((String)"operators", this.operators.iterator()), ChunkedToXContentHelper.chunk((b, p) -> b.field("sleeps", (ToXContent)this.sleeps)), ChunkedToXContentHelper.endObject()});
    }

    @Override
    public String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }
}

