/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanArrayVector;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ConstantBooleanVector;

public final class BooleanVectorFixedBuilder
implements BooleanVector.FixedBuilder {
    private final BlockFactory blockFactory;
    private final boolean[] values;
    private final long preAdjustedBytes;
    private int nextIndex;
    private boolean closed;

    BooleanVectorFixedBuilder(int size, BlockFactory blockFactory) {
        this.preAdjustedBytes = BooleanVectorFixedBuilder.ramBytesUsed(size);
        blockFactory.adjustBreaker(this.preAdjustedBytes);
        this.blockFactory = blockFactory;
        this.values = new boolean[size];
    }

    @Override
    public BooleanVectorFixedBuilder appendBoolean(boolean value) {
        this.values[this.nextIndex++] = value;
        return this;
    }

    @Override
    public BooleanVectorFixedBuilder appendBoolean(int idx, boolean value) {
        this.values[idx] = value;
        return this;
    }

    private static long ramBytesUsed(int size) {
        return size == 1 ? ConstantBooleanVector.RAM_BYTES_USED : BooleanArrayVector.BASE_RAM_BYTES_USED + RamUsageEstimator.alignObjectSize((long)((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)size * 1L));
    }

    @Override
    public long estimatedBytes() {
        return BooleanVectorFixedBuilder.ramBytesUsed(this.values.length);
    }

    @Override
    public BooleanVector build() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        this.closed = true;
        BooleanVector vector = this.values.length == 1 ? this.blockFactory.newConstantBooleanBlockWith(this.values[0], 1, this.preAdjustedBytes).asVector() : this.blockFactory.newBooleanArrayVector(this.values, this.values.length, this.preAdjustedBytes);
        assert (vector.ramBytesUsed() == this.preAdjustedBytes) : "fixed Builders should estimate the exact ram bytes used";
        return vector;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.blockFactory.adjustBreaker(-this.preAdjustedBytes);
        }
    }

    public boolean isReleased() {
        return this.closed;
    }
}

