/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.WelfordAlgorithm;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasables;

public final class StdDevStates {
    private StdDevStates() {
    }

    static final class GroupingState
    implements GroupingAggregatorState {
        private ObjectArray<WelfordAlgorithm> states;
        private final BigArrays bigArrays;

        GroupingState(BigArrays bigArrays) {
            this.states = bigArrays.newObjectArray(1L);
            this.bigArrays = bigArrays;
        }

        WelfordAlgorithm getOrNull(int position) {
            if ((long)position < this.states.size()) {
                return (WelfordAlgorithm)this.states.get((long)position);
            }
            return null;
        }

        public void combine(int groupId, WelfordAlgorithm state) {
            if (state == null) {
                return;
            }
            this.combine(groupId, state.mean(), state.m2(), state.count());
        }

        public void combine(int groupId, double meanValue, double m2Value, long countValue) {
            this.ensureCapacity(groupId);
            WelfordAlgorithm state = (WelfordAlgorithm)this.states.get((long)groupId);
            if (state == null) {
                state = new WelfordAlgorithm(meanValue, m2Value, countValue);
                this.states.set((long)groupId, (Object)state);
            } else {
                state.add(meanValue, m2Value, countValue);
            }
        }

        public WelfordAlgorithm getOrSet(int groupId) {
            this.ensureCapacity(groupId);
            WelfordAlgorithm state = (WelfordAlgorithm)this.states.get((long)groupId);
            if (state == null) {
                state = new WelfordAlgorithm();
                this.states.set((long)groupId, (Object)state);
            }
            return state;
        }

        public void add(int groupId, long value) {
            WelfordAlgorithm state = this.getOrSet(groupId);
            state.add(value);
        }

        public void add(int groupId, double value) {
            WelfordAlgorithm state = this.getOrSet(groupId);
            state.add(value);
        }

        public void add(int groupId, int value) {
            WelfordAlgorithm state = this.getOrSet(groupId);
            state.add(value);
        }

        private void ensureCapacity(int groupId) {
            this.states = this.bigArrays.grow(this.states, (long)(groupId + 1));
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 3) : "blocks=" + blocks.length + ",offset=" + offset;
            try (DoubleBlock.Builder meanBuilder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
                 DoubleBlock.Builder m2Builder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());
                 LongBlock.Builder countBuilder = driverContext.blockFactory().newLongBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    WelfordAlgorithm state;
                    int groupId = selected.getInt(i);
                    WelfordAlgorithm welfordAlgorithm = state = (long)groupId < this.states.size() ? (WelfordAlgorithm)this.states.get((long)groupId) : null;
                    if (state != null) {
                        meanBuilder.appendDouble(state.mean());
                        m2Builder.appendDouble(state.m2());
                        countBuilder.appendLong(state.count());
                        continue;
                    }
                    meanBuilder.appendDouble(0.0);
                    m2Builder.appendDouble(0.0);
                    countBuilder.appendLong(0L);
                }
                blocks[offset + 0] = meanBuilder.build();
                blocks[offset + 1] = m2Builder.build();
                blocks[offset + 2] = countBuilder.build();
            }
        }

        public Block evaluateFinal(IntVector selected, DriverContext driverContext) {
            try (DoubleBlock.Builder builder = driverContext.blockFactory().newDoubleBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    WelfordAlgorithm st = this.getOrNull(groupId);
                    if (st != null) {
                        double m2 = st.m2();
                        long count = st.count();
                        if (count == 0L || !Double.isFinite(m2)) {
                            builder.appendNull();
                            continue;
                        }
                        builder.appendDouble(st.evaluate());
                        continue;
                    }
                    builder.appendNull();
                }
                DoubleBlock doubleBlock = builder.build();
                return doubleBlock;
            }
        }

        public void close() {
            Releasables.close(this.states);
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }
    }

    static final class SingleState
    implements AggregatorState {
        private final WelfordAlgorithm welfordAlgorithm;

        SingleState() {
            this(0.0, 0.0, 0L);
        }

        SingleState(double mean, double m2, long count) {
            this.welfordAlgorithm = new WelfordAlgorithm(mean, m2, count);
        }

        public void add(long value) {
            this.welfordAlgorithm.add(value);
        }

        public void add(double value) {
            this.welfordAlgorithm.add(value);
        }

        public void add(int value) {
            this.welfordAlgorithm.add(value);
        }

        public void combine(double mean, double m2, long count) {
            this.welfordAlgorithm.add(mean, m2, count);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            assert (blocks.length >= offset + 3);
            BlockFactory blockFactory = driverContext.blockFactory();
            blocks[offset + 0] = blockFactory.newConstantDoubleBlockWith(this.mean(), 1);
            blocks[offset + 1] = blockFactory.newConstantDoubleBlockWith(this.m2(), 1);
            blocks[offset + 2] = blockFactory.newConstantLongBlockWith(this.count(), 1);
        }

        public void close() {
        }

        public double mean() {
            return this.welfordAlgorithm.mean();
        }

        public double m2() {
            return this.welfordAlgorithm.m2();
        }

        public long count() {
            return this.welfordAlgorithm.count();
        }

        public double evaluateFinal() {
            return this.welfordAlgorithm.evaluate();
        }

        public Block evaluateFinal(DriverContext driverContext) {
            long count = this.count();
            double m2 = this.m2();
            if (count == 0L || !Double.isFinite(m2)) {
                return driverContext.blockFactory().newConstantNullBlock(1);
            }
            return driverContext.blockFactory().newConstantDoubleBlockWith(this.evaluateFinal(), 1);
        }
    }
}

