/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SampleBooleanAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SampleBooleanAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("sample", ElementType.BYTES_REF));
    private final DriverContext driverContext;
    private final SampleBooleanAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;

    public SampleBooleanAggregatorFunction(DriverContext driverContext, List<Integer> channels, SampleBooleanAggregator.SingleState state, int limit) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
    }

    public static SampleBooleanAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit) {
        return new SampleBooleanAggregatorFunction(driverContext, channels, SampleBooleanAggregator.initSingle(driverContext.bigArrays(), limit), limit);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        BooleanBlock valueBlock = (BooleanBlock)page.getBlock(this.channels.get(0));
        BooleanVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, mask);
            return;
        }
        this.addRawVector(valueVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        BooleanBlock valueBlock = (BooleanBlock)page.getBlock(this.channels.get(0));
        BooleanVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock);
            return;
        }
        this.addRawVector(valueVector);
    }

    private void addRawVector(BooleanVector valueVector) {
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            boolean valueValue = valueVector.getBoolean(valuesPosition);
            SampleBooleanAggregator.combine(this.state, valueValue);
        }
    }

    private void addRawVector(BooleanVector valueVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            boolean valueValue = valueVector.getBoolean(valuesPosition);
            SampleBooleanAggregator.combine(this.state, valueValue);
        }
    }

    private void addRawBlock(BooleanBlock valueBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (valueBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                boolean valueValue = valueBlock.getBoolean(valueOffset);
                SampleBooleanAggregator.combine(this.state, valueValue);
            }
        }
    }

    private void addRawBlock(BooleanBlock valueBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || valueBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                boolean valueValue = valueBlock.getBoolean(valueOffset);
                SampleBooleanAggregator.combine(this.state, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SampleBooleanAggregatorFunction.intermediateStateDesc().size());
        Object sampleUncast = page.getBlock(this.channels.get(0));
        if (sampleUncast.areAllValuesNull()) {
            return;
        }
        BytesRefBlock sample = (BytesRefBlock)sampleUncast;
        assert (sample.getPositionCount() == 1);
        BytesRef scratch = new BytesRef();
        SampleBooleanAggregator.combineIntermediate(this.state, sample);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SampleBooleanAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

