/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.compute.aggregation.AbstractArrayState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class IpArrayState
extends AbstractArrayState
implements GroupingAggregatorState {
    private static final int IP_LENGTH = 16;
    private final byte[] init;
    private ByteArray values;

    IpArrayState(BigArrays bigArrays, BytesRef init) {
        super(bigArrays);
        assert (init.length == 16);
        this.values = bigArrays.newByteArray(16L, false);
        this.init = new byte[16];
        System.arraycopy(init.bytes, init.offset, this.init, 0, 16);
        this.values.set(0L, this.init, 0, 16);
    }

    BytesRef get(int groupId, BytesRef scratch) {
        int ipIndex = this.getIndex(groupId);
        this.values.get((long)ipIndex, 16, scratch);
        return scratch;
    }

    BytesRef getOrDefault(int groupId, BytesRef scratch) {
        int ipIndex = this.getIndex(groupId);
        if ((long)(ipIndex + 16) <= this.values.size()) {
            this.values.get((long)ipIndex, 16, scratch);
        } else {
            scratch.bytes = this.init;
            scratch.offset = 0;
            scratch.length = 16;
        }
        return scratch;
    }

    void set(int groupId, BytesRef ip) {
        assert (ip.length == 16);
        this.ensureCapacity(groupId);
        int ipIndex = this.getIndex(groupId);
        this.values.set((long)ipIndex, ip.bytes, ip.offset, ip.length);
        this.trackGroupId(groupId);
    }

    Block toValuesBlock(IntVector selected, DriverContext driverContext) {
        BytesRef scratch = new BytesRef();
        if (!this.trackingGroupIds()) {
            try (BytesRefVector.Builder builder = driverContext.blockFactory().newBytesRefVectorBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int group = selected.getInt(i);
                    BytesRef value = this.get(group, scratch);
                    builder.appendBytesRef(value);
                }
                BytesRefBlock i = builder.build().asBlock();
                return i;
            }
        }
        try (BytesRefBlock.Builder builder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                if (this.hasValue(group)) {
                    BytesRef value = this.get(group, scratch);
                    builder.appendBytesRef(value);
                    continue;
                }
                builder.appendNull();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private void ensureCapacity(int groupId) {
        int minIpIndex = this.getIndex(groupId);
        int minSize = minIpIndex + 16;
        if ((long)minSize > this.values.size()) {
            long prevSize = this.values.size();
            this.values = this.bigArrays.grow(this.values, (long)minSize);
            long prevLastIpIndex = prevSize - prevSize % 16L;
            long lastIpIndex = this.values.size() - this.values.size() % 16L;
            for (long i = prevLastIpIndex; i < lastIpIndex; i += 16L) {
                this.values.set(i, this.init, 0, 16);
            }
        }
    }

    @Override
    public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        assert (blocks.length >= offset + 2);
        try (BytesRefBlock.Builder valuesBuilder = driverContext.blockFactory().newBytesRefBlockBuilder(selected.getPositionCount());
             BooleanVector.FixedBuilder hasValueBuilder = driverContext.blockFactory().newBooleanVectorFixedBuilder(selected.getPositionCount());){
            BytesRef scratch = new BytesRef();
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                int group = selected.getInt(i);
                int ipIndex = this.getIndex(group);
                if ((long)(ipIndex + 16) <= this.values.size()) {
                    BytesRef value = this.get(group, scratch);
                    valuesBuilder.appendBytesRef(value);
                } else {
                    scratch.length = 0;
                    valuesBuilder.appendBytesRef(scratch);
                }
                hasValueBuilder.appendBoolean(i, this.hasValue(group));
            }
            blocks[offset] = valuesBuilder.build();
            blocks[offset + 1] = hasValueBuilder.build().asBlock();
        }
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, () -> super.close()});
    }

    private int getIndex(int groupId) {
        return groupId * 16;
    }
}

