/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.apmintegration;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.telemetry.metric.DoubleCounter;
import org.elasticsearch.telemetry.metric.DoubleHistogram;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class TestMeterUsages {
    private static final Logger logger = LogManager.getLogger(TestMeterUsages.class);
    private final DoubleCounter doubleCounter;
    private final DoubleCounter longCounter;
    private final DoubleHistogram doubleHistogram;
    private final LongHistogram longHistogram;
    private final AtomicReference<DoubleWithAttributes> doubleWithAttributes = new AtomicReference();
    private final AtomicReference<LongWithAttributes> longWithAttributes = new AtomicReference();

    public TestMeterUsages(MeterRegistry meterRegistry) {
        this.doubleCounter = meterRegistry.registerDoubleCounter("es.test.long_counter.total", "test", "unit");
        this.longCounter = meterRegistry.registerDoubleCounter("es.test.double_counter.total", "test", "unit");
        this.doubleHistogram = meterRegistry.registerDoubleHistogram("es.test.double_histogram.histogram", "test", "unit");
        this.longHistogram = meterRegistry.registerLongHistogram("es.test.long_histogram.histogram", "test", "unit");
        meterRegistry.registerDoubleGauge("es.test.double_gauge.current", "test", "unit", () -> {
            DoubleWithAttributes value = this.doubleWithAttributes.get();
            logger.trace("[es.test.double_gauge.current] callback with value [{}]", new Object[]{value});
            return value;
        });
        meterRegistry.registerLongGauge("es.test.long_gauge.current", "test", "unit", () -> {
            LongWithAttributes value = this.longWithAttributes.get();
            logger.trace("[es.test.long_gauge.current] callback with value [{}]", new Object[]{value});
            return value;
        });
        meterRegistry.registerLongAsyncCounter("es.test.async_long_counter.total", "test", "unit", () -> {
            LongWithAttributes value = this.longWithAttributes.get();
            logger.trace("[es.test.async_long_counter.total] callback with value [{}]", new Object[]{value});
            return value;
        });
        meterRegistry.registerDoubleAsyncCounter("es.test.async_double_counter.total", "test", "unit", () -> {
            DoubleWithAttributes value = this.doubleWithAttributes.get();
            logger.trace("[es.test.async_double_counter.total] callback with value [{}]", new Object[]{value});
            return value;
        });
    }

    public void testUponRequest() {
        logger.info("setting counters");
        this.doubleCounter.increment();
        this.longCounter.increment();
        this.doubleHistogram.record(1.0);
        this.doubleHistogram.record(2.0);
        this.longHistogram.record(1L);
        this.longHistogram.record(2L);
        logger.trace("setting async counters");
        this.doubleWithAttributes.set(new DoubleWithAttributes(1.0, Map.of()));
        this.longWithAttributes.set(new LongWithAttributes(1L, Map.of()));
    }
}

