/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.rerank;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.search.rank.RankShardResult;
import org.elasticsearch.search.rank.context.QueryPhaseRankShardContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.feature.RankFeatureShardResult;

public class RerankingQueryPhaseRankShardContext
extends QueryPhaseRankShardContext {
    public RerankingQueryPhaseRankShardContext(List<Query> queries, int windowSize) {
        super(queries, windowSize);
    }

    @Override
    public RankShardResult combineQueryPhaseResults(List<TopDocs> rankResults) {
        HashMap rankDocs = new HashMap();
        rankResults.forEach(topDocs -> {
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                rankDocs.compute(scoreDoc.doc, (key, value) -> {
                    if (value == null) {
                        return new RankFeatureDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex);
                    }
                    value.score = Math.max(scoreDoc.score, ((RankFeatureDoc)rankDocs.get((Object)Integer.valueOf((int)scoreDoc.doc))).score);
                    return value;
                });
            }
        });
        RankFeatureDoc[] sortedResults = (RankFeatureDoc[])rankDocs.values().toArray(RankFeatureDoc[]::new);
        Arrays.sort(sortedResults, (o1, o2) -> Float.compare(o2.score, o1.score));
        return new RankFeatureShardResult(sortedResults);
    }
}

