/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public abstract class SourceValueFetcherIndexFieldData<T>
implements IndexFieldData<SourceValueFetcherLeafFieldData<T>> {
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;
    protected final ValueFetcher valueFetcher;
    protected final SourceProvider sourceProvider;
    protected final ToScriptFieldFactory<T> toScriptFieldFactory;

    protected SourceValueFetcherIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<T> toScriptFieldFactory) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
        this.valueFetcher = valueFetcher;
        this.sourceProvider = sourceProvider;
        this.toScriptFieldFactory = toScriptFieldFactory;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public SourceValueFetcherLeafFieldData<T> load(LeafReaderContext context) {
        try {
            return (SourceValueFetcherLeafFieldData)this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("not supported for source fallback");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("not supported for source fallback");
    }

    public static abstract class SourceValueFetcherLeafFieldData<T>
    implements LeafFieldData {
        protected final ToScriptFieldFactory<T> toScriptFieldFactory;
        protected final LeafReaderContext leafReaderContext;
        protected final ValueFetcher valueFetcher;
        protected final SourceProvider sourceProvider;

        public SourceValueFetcherLeafFieldData(ToScriptFieldFactory<T> toScriptFieldFactory, LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            this.toScriptFieldFactory = toScriptFieldFactory;
            this.leafReaderContext = leafReaderContext;
            this.valueFetcher = valueFetcher;
            this.sourceProvider = sourceProvider;
        }

        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public SortedBinaryDocValues getBytesValues() {
            throw new IllegalArgumentException("not supported for source fallback");
        }
    }

    public static interface ValueFetcherDocValues {
    }

    public static abstract class Builder<T>
    implements IndexFieldData.Builder {
        protected final String fieldName;
        protected final ValuesSourceType valuesSourceType;
        protected final ValueFetcher valueFetcher;
        protected final SourceProvider sourceProvider;
        protected final ToScriptFieldFactory<T> toScriptFieldFactory;

        public Builder(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<T> toScriptFieldFactory) {
            this.fieldName = fieldName;
            this.valuesSourceType = valuesSourceType;
            this.valueFetcher = valueFetcher;
            this.sourceProvider = sourceProvider;
            this.toScriptFieldFactory = toScriptFieldFactory;
        }
    }
}

