/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.io.IOException;
import java.util.function.IntConsumer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.internal.hppc.IntHashSet;
import org.apache.lucene.util.BytesRef;

public class TrackingPostingsInMemoryBytesCodec
extends FilterCodec {
    public static final String IN_MEMORY_POSTINGS_BYTES_KEY = "es.postings.in_memory_bytes";

    public TrackingPostingsInMemoryBytesCodec(Codec delegate) {
        super(delegate.getName(), delegate);
    }

    public PostingsFormat postingsFormat() {
        final PostingsFormat format = super.postingsFormat();
        return new PostingsFormat(this, format.getName()){

            public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
                FieldsConsumer consumer = format.fieldsConsumer(state);
                return new TrackingLengthFieldsConsumer(state, consumer);
            }

            public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
                return format.fieldsProducer(state);
            }
        };
    }

    static final class TrackingLengthTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        int maxTermLength = 0;
        int minTermLength = 0;
        int termCount = 0;
        final IntConsumer onFinish;

        TrackingLengthTermsEnum(TermsEnum in, IntConsumer onFinish) {
            super(in);
            this.onFinish = onFinish;
        }

        public BytesRef next() throws IOException {
            BytesRef term = super.next();
            if (term != null) {
                if (this.termCount == 0) {
                    this.minTermLength = term.length;
                }
                this.maxTermLength = term.length;
                ++this.termCount;
            } else if (this.termCount == 1) {
                assert (this.minTermLength == this.maxTermLength);
                this.onFinish.accept(this.maxTermLength);
            } else {
                this.onFinish.accept(this.maxTermLength + this.minTermLength);
            }
            return term;
        }
    }

    static final class TrackingLengthTerms
    extends FilterLeafReader.FilterTerms {
        final IntConsumer onFinish;

        TrackingLengthTerms(Terms in, IntConsumer onFinish) {
            super(in);
            this.onFinish = onFinish;
        }

        public TermsEnum iterator() throws IOException {
            return new TrackingLengthTermsEnum(super.iterator(), this.onFinish);
        }
    }

    static final class TrackingLengthFields
    extends FilterLeafReader.FilterFields {
        final FieldInfos fieldInfos;
        final IntHashSet seenFields;
        final long[] totalBytes;

        TrackingLengthFields(Fields in, FieldInfos fieldInfos, IntHashSet seenFields, long[] totalBytes) {
            super(in);
            this.seenFields = seenFields;
            this.fieldInfos = fieldInfos;
            this.totalBytes = totalBytes;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = super.terms(field);
            if (terms == null) {
                return null;
            }
            int fieldNum = this.fieldInfos.fieldInfo((String)field).number;
            if (this.seenFields.add(fieldNum)) {
                return new TrackingLengthTerms(terms, bytes -> {
                    this.totalBytes[0] = this.totalBytes[0] + (long)bytes;
                });
            }
            return terms;
        }
    }

    static final class TrackingLengthFieldsConsumer
    extends FieldsConsumer {
        final SegmentWriteState state;
        final FieldsConsumer in;
        final IntHashSet seenFields;
        final long[] totalBytes;

        TrackingLengthFieldsConsumer(SegmentWriteState state, FieldsConsumer in) {
            this.state = state;
            this.in = in;
            this.totalBytes = new long[1];
            this.seenFields = new IntHashSet(state.fieldInfos.size());
        }

        public void write(Fields fields, NormsProducer norms) throws IOException {
            this.in.write((Fields)new TrackingLengthFields(fields, this.state.fieldInfos, this.seenFields, this.totalBytes), norms);
            this.state.segmentInfo.putAttribute(TrackingPostingsInMemoryBytesCodec.IN_MEMORY_POSTINGS_BYTES_KEY, Long.toString(this.totalBytes[0]));
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

