/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.elasticsearch.common.time.DateTimePrinter;

class JavaTimeDateTimePrinter
implements DateTimePrinter {
    private final DateTimeFormatter formatter;

    JavaTimeDateTimePrinter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public ZoneId getZone() {
        return this.formatter.getZone();
    }

    @Override
    public Locale getLocale() {
        return this.formatter.getLocale();
    }

    @Override
    public DateTimePrinter withZone(ZoneId zone) {
        return new JavaTimeDateTimePrinter(this.formatter.withZone(zone));
    }

    @Override
    public DateTimePrinter withLocale(Locale locale) {
        return new JavaTimeDateTimePrinter(this.formatter.withLocale(locale));
    }

    @Override
    public String format(TemporalAccessor accessor) {
        return this.formatter.format(accessor);
    }
}

