/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class BaseNodesResponse<TNodeResponse extends BaseNodeResponse>
extends ActionResponse {
    private final ClusterName clusterName;
    private final List<FailedNodeException> failures;
    private final List<TNodeResponse> nodes;
    private Map<String, TNodeResponse> nodesMap;

    protected BaseNodesResponse(StreamInput in) throws IOException {
        this.clusterName = new ClusterName(in);
        this.nodes = this.readNodesFrom(in);
        this.failures = in.readCollectionAsList(FailedNodeException::new);
    }

    protected BaseNodesResponse(ClusterName clusterName, List<TNodeResponse> nodes, List<FailedNodeException> failures) {
        this.clusterName = Objects.requireNonNull(clusterName);
        this.failures = Objects.requireNonNull(failures);
        this.nodes = Objects.requireNonNull(nodes);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public List<FailedNodeException> failures() {
        return this.failures;
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public List<TNodeResponse> getNodes() {
        return this.nodes;
    }

    public Map<String, TNodeResponse> getNodesMap() {
        if (this.nodesMap == null) {
            this.nodesMap = new HashMap<String, TNodeResponse>();
            for (BaseNodeResponse nodeResponse : this.nodes) {
                this.nodesMap.put(nodeResponse.getNode().getId(), nodeResponse);
            }
        }
        return this.nodesMap;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        this.writeNodesTo(out, this.nodes);
        out.writeCollection(this.failures);
    }

    protected abstract List<TNodeResponse> readNodesFrom(StreamInput var1) throws IOException;

    protected abstract void writeNodesTo(StreamOutput var1, List<TNodeResponse> var2) throws IOException;
}

