/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;

public final class ChannelActionListener<Response extends TransportResponse>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(ChannelActionListener.class);
    private final TransportChannel channel;

    public ChannelActionListener(TransportChannel channel) {
        this.channel = channel;
    }

    @Override
    public void onResponse(Response response) {
        try {
            this.channel.sendResponse((TransportResponse)response);
        }
        catch (RuntimeException e) {
            String message = Strings.format((String)"channel [%s] threw exceptions on sendResponse", (Object[])new Object[]{this.channel});
            assert (false) : new AssertionError(message, e);
            logger.error(() -> message, (Throwable)e);
            throw e;
        }
    }

    @Override
    public void onFailure(Exception e) {
        try {
            this.channel.sendResponse(e);
        }
        catch (RuntimeException sendException) {
            sendException.addSuppressed(e);
            String message = Strings.format((String)"channel [%s] threw exceptions on sendResponse", (Object[])new Object[]{this.channel});
            assert (false) : new AssertionError(message, sendException);
            logger.error(() -> message, (Throwable)sendException);
            throw sendException;
        }
    }

    public String toString() {
        return "ChannelActionListener{" + String.valueOf(this.channel) + "}";
    }
}

