/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record IndexDescription(IndexId indexId, @Nullable String indexMetadataBlob, int shardCount) implements Writeable,
ToXContentObject
{
    public IndexDescription {
        if (indexId == null || shardCount < 0) {
            throw new IllegalArgumentException("invalid IndexDescription");
        }
    }

    public IndexDescription(StreamInput in) throws IOException {
        this(new IndexId(in), in.readOptionalString(), in.readVInt());
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.indexId.writeTo(out);
        out.writeOptionalString(this.indexMetadataBlob);
        out.writeVInt(this.shardCount);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.indexId.getName());
        builder.field("uuid", this.indexId.getId());
        if (this.indexMetadataBlob != null) {
            builder.field("metadata_blob", this.indexMetadataBlob);
        }
        if (this.shardCount > 0) {
            builder.field("shards", this.shardCount);
        }
        return builder.endObject();
    }
}

