/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.analysis;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.elasticsearch.xpack.eql.expression.OptionalResolvedAttribute;
import org.elasticsearch.xpack.eql.expression.OptionalUnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;

public final class AnalysisUtils {
    private AnalysisUtils() {
    }

    static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList) {
        return AnalysisUtils.resolveAgainstList(u, attrList, false);
    }

    static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, boolean allowCompound) {
        LinkedHashSet<Attribute> matches = new LinkedHashSet<Attribute>();
        boolean qualified = u.qualifier() != null;
        for (Attribute attribute : attrList) {
            boolean match;
            if (attribute.synthetic() || !(match = qualified ? Objects.equals(u.qualifiedName(), attribute.qualifiedName()) : Objects.equals(u.name(), attribute.name()) || Objects.equals(u.name(), attribute.qualifiedName()))) continue;
            matches.add(attribute.withLocation(u.source()));
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return AnalysisUtils.handleSpecialFields(u, (Attribute)matches.iterator().next(), allowCompound);
        }
        return u.withUnresolvedMessage("Reference [" + u.qualifiedName() + "] is ambiguous (to disambiguate use quotes or qualifiers); matches any of " + String.valueOf(matches.stream().map(a -> "\"" + a.qualifier() + "\".\"" + a.name() + "\"").sorted().toList()));
    }

    private static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named, boolean allowCompound) {
        if (named instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)named;
            EsField esField = fa.field();
            if (esField instanceof InvalidMappedField) {
                InvalidMappedField field = (InvalidMappedField)esField;
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] due to ambiguities being " + field.errorMessage());
            } else if (DataTypes.isUnsupported((DataType)fa.dataType())) {
                UnsupportedEsField unsupportedField = (UnsupportedEsField)fa.field();
                named = unsupportedField.hasInherited() ? u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "] in hierarchy (field [" + unsupportedField.getInherited() + "])") : u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "]");
            } else if (!allowCompound && !DataTypes.isPrimitive((DataType)fa.dataType()) && fa.dataType() != DataTypes.NESTED) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + fa.dataType().typeName() + "] only its subfields");
            } else if (fa.dataType() == DataTypes.NESTED) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + fa.dataType().typeName() + "] due to nested fields not being supported yet");
            } else if (fa.isNested()) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + fa.dataType().typeName() + "] with unsupported nested type in hierarchy (field [" + fa.nestedParent().name() + "])");
            } else if (u instanceof OptionalUnresolvedAttribute) {
                named = new OptionalResolvedAttribute(fa);
            }
        } else if (u instanceof OptionalUnresolvedAttribute) {
            named = u.withUnresolvedMessage("Unsupported optional field [" + named.name() + "] type [" + named.dataType().typeName());
        }
        return named;
    }
}

