/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedBatchedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.migrate.action.CopyLifecycleIndexMetadataAction;

public class CopyLifecycleIndexMetadataTransportAction
extends TransportMasterNodeAction<CopyLifecycleIndexMetadataAction.Request, AcknowledgedResponse> {
    private final ClusterStateTaskExecutor<UpdateIndexMetadataTask> executor = new SimpleBatchedAckListenerTaskExecutor<UpdateIndexMetadataTask>(this){

        public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateIndexMetadataTask task, ClusterState state) {
            ProjectMetadata projectMetadata = state.metadata().getProject(task.projectId);
            ProjectMetadata updatedMetadata = CopyLifecycleIndexMetadataTransportAction.applyUpdate(projectMetadata, task);
            return new Tuple((Object)ClusterState.builder((ClusterState)state).putProjectMetadata(updatedMetadata).build(), (Object)task);
        }
    };
    private final MasterServiceTaskQueue<UpdateIndexMetadataTask> taskQueue;
    private final ProjectResolver projectResolver;

    @Inject
    public CopyLifecycleIndexMetadataTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super("indices:admin/index/copy_lifecycle_index_metadata", transportService, clusterService, threadPool, actionFilters, CopyLifecycleIndexMetadataAction.Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.taskQueue = clusterService.createTaskQueue("migrate-copy-index-metadata", Priority.NORMAL, this.executor);
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, CopyLifecycleIndexMetadataAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.taskQueue.submitTask("migrate-copy-index-metadata", (ClusterStateTaskListener)new UpdateIndexMetadataTask(this.projectResolver.getProjectId(), request.sourceIndex(), request.destIndex(), request.ackTimeout(), listener), request.masterNodeTimeout());
    }

    protected ClusterBlockException checkBlock(CopyLifecycleIndexMetadataAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private static ProjectMetadata applyUpdate(ProjectMetadata projectMetadata, UpdateIndexMetadataTask updateTask) {
        assert (projectMetadata != null && updateTask != null);
        assert (Objects.equals(updateTask.projectId, projectMetadata.id()));
        IndexMetadata sourceMetadata = projectMetadata.index(updateTask.sourceIndex);
        if (sourceMetadata == null) {
            throw new IndexNotFoundException(updateTask.sourceIndex);
        }
        IndexMetadata destMetadata = projectMetadata.index(updateTask.destIndex);
        if (destMetadata == null) {
            throw new IndexNotFoundException(updateTask.destIndex);
        }
        IndexMetadata.Builder newDestMetadata = IndexMetadata.builder((IndexMetadata)destMetadata);
        Map sourceILM = sourceMetadata.getCustomData("ilm");
        if (sourceILM != null) {
            newDestMetadata.putCustom("ilm", sourceILM);
        }
        newDestMetadata.putRolloverInfos(sourceMetadata.getRolloverInfos()).creationDate(sourceMetadata.getCreationDate()).settingsVersion(destMetadata.getSettingsVersion() + 1L);
        HashMap<String, IndexMetadata> indices = new HashMap<String, IndexMetadata>(projectMetadata.indices());
        indices.put(updateTask.destIndex, newDestMetadata.build());
        return ProjectMetadata.builder((ProjectMetadata)projectMetadata).indices(indices).build();
    }

    static class UpdateIndexMetadataTask
    extends AckedBatchedClusterStateUpdateTask {
        private final ProjectId projectId;
        private final String sourceIndex;
        private final String destIndex;

        UpdateIndexMetadataTask(ProjectId projectId, String sourceIndex, String destIndex, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.projectId = projectId;
            this.sourceIndex = sourceIndex;
            this.destIndex = destIndex;
        }
    }
}

