/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.datastreams.DeleteDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteDataStreamAction
extends AcknowledgedTransportMasterNodeAction<DeleteDataStreamAction.Request> {
    private static final Logger LOGGER = LogManager.getLogger(TransportDeleteDataStreamAction.class);
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SystemIndices systemIndices;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportDeleteDataStreamAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, ProjectResolver projectResolver) {
        super("indices:admin/data_stream/delete", transportService, clusterService, threadPool, actionFilters, DeleteDataStreamAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.systemIndices = systemIndices;
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, final DeleteDataStreamAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        final ProjectState projectState = this.projectResolver.getProjectState(state);
        List names = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ProjectMetadata)projectState.metadata(), (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        for (String name : names) {
            this.systemIndices.validateDataStreamAccess(name, this.threadPool.getThreadContext());
        }
        this.submitUnbatchedTask("remove-data-stream [" + Strings.arrayToCommaDelimitedString((Object[])request.getNames()) + "]", new ClusterStateUpdateTask(Priority.HIGH, request.masterNodeTimeout()){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public ClusterState execute(ClusterState currentState) {
                return TransportDeleteDataStreamAction.removeDataStream(TransportDeleteDataStreamAction.this.indexNameExpressionResolver, currentState.projectState(projectState.projectId()), request, ds -> TransportDeleteDataStreamAction.this.systemIndices.validateDataStreamAccess(ds, TransportDeleteDataStreamAction.this.threadPool.getThreadContext()), TransportDeleteDataStreamAction.this.clusterService.getSettings());
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState removeDataStream(IndexNameExpressionResolver indexNameExpressionResolver, ProjectState projectState, DeleteDataStreamAction.Request request, Consumer<String> systemDataStreamAccessValidator, Settings settings) {
        ProjectMetadata project = projectState.metadata();
        List names = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)indexNameExpressionResolver, (ProjectMetadata)project, (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        HashSet dataStreams = new HashSet(names);
        for (String dataStreamName : dataStreams) {
            systemDataStreamAccessValidator.accept(dataStreamName);
        }
        if (dataStreams.isEmpty()) {
            if (request.isWildcardExpressionsOriginallySpecified()) {
                return projectState.cluster();
            }
            throw new ResourceNotFoundException("data streams " + Arrays.toString(request.getNames()) + " not found", new Object[0]);
        }
        return MetadataDataStreamsService.deleteDataStreams((ProjectState)projectState, dataStreams.stream().map(project.dataStreams()::get).collect(Collectors.toSet()), (Settings)settings);
    }

    protected ClusterBlockException checkBlock(DeleteDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

