/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.h3;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.h3.LatLng;

public final class CellBoundary {
    static final int MAX_CELL_BNDRY_VERTS = 10;
    private final int numPoints;
    private final LatLng[] points;

    CellBoundary(LatLng[] points, int numPoints) {
        this.points = points;
        this.numPoints = numPoints;
    }

    public int numPoints() {
        return this.numPoints;
    }

    public LatLng getLatLon(int i) {
        assert (i >= 0 && i < this.numPoints);
        return this.points[i];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellBoundary that = (CellBoundary)o;
        return this.numPoints == that.numPoints && Arrays.equals(this.points, that.points);
    }

    public int hashCode() {
        return Objects.hash(this.numPoints, Arrays.hashCode(this.points));
    }
}

