/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.index;

import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.LinkedProjectConfig;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.transport.RemoteClusterAware;

public final class RemoteClusterResolver
extends RemoteClusterAware {
    private final CopyOnWriteArraySet<String> clusters;

    public RemoteClusterResolver(Settings settings, LinkedProjectConfigService linkedProjectConfigService) {
        super(settings);
        this.clusters = new CopyOnWriteArraySet<String>(linkedProjectConfigService.getInitialLinkedProjectConfigs().stream().map(LinkedProjectConfig::linkedProjectAlias).toList());
        linkedProjectConfigService.register((LinkedProjectConfigService.LinkedProjectConfigListener)this);
    }

    public void updateLinkedProject(LinkedProjectConfig config) {
        if (config.isConnectionEnabled()) {
            this.clusters.add(config.linkedProjectAlias());
        } else {
            this.clusters.remove(config.linkedProjectAlias());
        }
    }

    public Set<String> remoteClusters() {
        return new TreeSet<String>(this.clusters);
    }
}

