/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.spi;

import com.nvidia.cuvs.spi.CuVSProvider;
import com.nvidia.cuvs.spi.ProviderInitializationException;
import com.nvidia.cuvs.spi.UnsupportedProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.ServiceLoader;

public abstract class CuVSServiceProvider {
    public abstract CuVSProvider get(CuVSProvider var1);

    static class Holder {
        static final CuVSProvider INSTANCE = Holder.loadProvider();

        Holder() {
        }

        private static CuVSProvider loadProvider() {
            CuVSProvider builtinProvider = Holder.builtinProvider();
            return ServiceLoader.load(CuVSServiceProvider.class).findFirst().map(p -> p.get(builtinProvider)).orElse(builtinProvider);
        }

        static CuVSProvider builtinProvider() {
            boolean supportedJavaRuntime = Runtime.version().feature() > 21;
            boolean supportedOs = System.getProperty("os.name").startsWith("Linux");
            boolean supportedArchitecture = System.getProperty("os.arch").equals("amd64");
            if (supportedJavaRuntime && supportedOs && supportedArchitecture) {
                try {
                    Class<?> cls = Class.forName("com.nvidia.cuvs.spi.JDKProvider");
                    MethodHandle ctr = MethodHandles.lookup().findStatic(cls, "create", MethodType.methodType(CuVSProvider.class));
                    return ctr.invoke();
                }
                catch (ProviderInitializationException e) {
                    return new UnsupportedProvider("Cannot create JDKProvider: " + e.getMessage());
                }
                catch (Throwable e) {
                    throw new AssertionError((Object)e);
                }
            }
            ArrayList<String> unsupportedReasons = new ArrayList<String>();
            if (!supportedJavaRuntime) {
                unsupportedReasons.add("cuvs-java requires Java Runtime version 22 or greater");
            }
            if (!supportedOs) {
                unsupportedReasons.add("cuvs-java supports only Linux");
            }
            if (!supportedArchitecture) {
                unsupportedReasons.add("cuvs-java supports only x86");
            }
            return new UnsupportedProvider(String.join((CharSequence)"; ", unsupportedReasons));
        }
    }
}

