/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.llama.completion;

import java.util.Map;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.llama.LlamaModel;
import org.elasticsearch.xpack.inference.services.llama.action.LlamaActionVisitor;
import org.elasticsearch.xpack.inference.services.llama.completion.LlamaChatCompletionServiceSettings;

public class LlamaChatCompletionModel
extends LlamaModel {
    public LlamaChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, LlamaChatCompletionServiceSettings.fromMap(serviceSettings, context), LlamaChatCompletionModel.retrieveSecretSettings(secrets));
    }

    public LlamaChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, LlamaChatCompletionServiceSettings serviceSettings, SecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)EmptyTaskSettings.INSTANCE), new ModelSecrets(secrets));
        this.setPropertiesFromServiceSettings(serviceSettings);
    }

    public static LlamaChatCompletionModel of(LlamaChatCompletionModel model, UnifiedCompletionRequest request) {
        if (request.model() == null) {
            return model;
        }
        LlamaChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        LlamaChatCompletionServiceSettings overriddenServiceSettings = new LlamaChatCompletionServiceSettings(request.model(), originalModelServiceSettings.uri(), originalModelServiceSettings.rateLimitSettings());
        return new LlamaChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getSecretSettings());
    }

    private void setPropertiesFromServiceSettings(LlamaChatCompletionServiceSettings serviceSettings) {
        this.uri = serviceSettings.uri();
        this.rateLimitSettings = serviceSettings.rateLimitSettings();
    }

    public LlamaChatCompletionServiceSettings getServiceSettings() {
        return (LlamaChatCompletionServiceSettings)super.getServiceSettings();
    }

    @Override
    public ExecutableAction accept(LlamaActionVisitor creator) {
        return creator.create(this);
    }
}

