/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.request.completion;

import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleModelGardenProvider;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiRequest;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.completion.GoogleModelGardenAnthropicChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.completion.GoogleVertexAiUnifiedChatCompletionRequestEntity;

public class GoogleVertexAiUnifiedChatCompletionRequest
implements GoogleVertexAiRequest {
    private final GoogleVertexAiChatCompletionModel model;
    private final UnifiedChatInput unifiedChatInput;
    private final URI uri;

    public GoogleVertexAiUnifiedChatCompletionRequest(UnifiedChatInput unifiedChatInput, GoogleVertexAiChatCompletionModel model) {
        this.model = Objects.requireNonNull(model);
        this.unifiedChatInput = Objects.requireNonNull(unifiedChatInput);
        this.uri = unifiedChatInput.stream() ? model.streamingURI() : model.nonStreamingUri();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        ToXContentObject requestEntity = this.createRequestEntity();
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)requestEntity).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.decorateWithAuth(httpPost);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    private ToXContentObject createRequestEntity() {
        GoogleModelGardenProvider googleModelGardenProvider = this.model.getServiceSettings().provider();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ANTHROPIC", "GOOGLE"}, (GoogleModelGardenProvider)googleModelGardenProvider, n)) {
            case 0: {
                return new GoogleModelGardenAnthropicChatCompletionRequestEntity(this.unifiedChatInput, this.model.getTaskSettings());
            }
            case 1: {
                return new GoogleVertexAiUnifiedChatCompletionRequestEntity(this.unifiedChatInput, this.model.getTaskSettings().thinkingConfig());
            }
        }
        throw new ElasticsearchException("Unsupported Google Model Garden provider: " + String.valueOf((Object)this.model.getServiceSettings().provider()), new Object[0]);
    }

    public void decorateWithAuth(HttpPost httpPost) {
        GoogleVertexAiRequest.decorateWithBearerToken(httpPost, this.model.getSecretSettings());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    @Override
    public boolean isStreaming() {
        return this.unifiedChatInput.stream();
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }
}

