/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.Flow;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ChatCompletionErrorResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponse;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiResponseHandler;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiUnifiedStreamingProcessor;
import org.elasticsearch.xpack.inference.services.googlevertexai.response.GoogleVertexAiCompletionResponseEntity;

public class GoogleVertexAiUnifiedChatCompletionResponseHandler
extends GoogleVertexAiResponseHandler {
    private static final String ERROR_FIELD = "error";
    private static final String ERROR_CODE_FIELD = "code";
    private static final String ERROR_MESSAGE_FIELD = "message";
    private static final String ERROR_STATUS_FIELD = "status";
    private static final GoogleVertexAiErrorParser ERROR_PARSER = new GoogleVertexAiErrorParser();
    private final ChatCompletionErrorResponseHandler chatCompletionErrorResponseHandler = new ChatCompletionErrorResponseHandler(ERROR_PARSER);

    public GoogleVertexAiUnifiedChatCompletionResponseHandler(String requestType) {
        super(requestType, GoogleVertexAiCompletionResponseEntity::fromResponse, GoogleVertexAiErrorResponse::fromResponse, true);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        assert (request.isStreaming()) : "GoogleVertexAiUnifiedChatCompletionResponseHandler only supports streaming requests";
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        GoogleVertexAiUnifiedStreamingProcessor googleVertexAiProcessor = new GoogleVertexAiUnifiedStreamingProcessor((m, e) -> this.chatCompletionErrorResponseHandler.buildMidStreamChatCompletionError(request.getInferenceEntityId(), (String)m, (Exception)e));
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(googleVertexAiProcessor);
        return new StreamingUnifiedChatCompletionResults((Flow.Publisher)googleVertexAiProcessor);
    }

    protected UnifiedChatCompletionException buildError(String message, Request request, HttpResult result) {
        return this.chatCompletionErrorResponseHandler.buildChatCompletionError(message, request, result);
    }

    private static class GoogleVertexAiErrorParser
    implements UnifiedChatCompletionErrorParserContract {
        private GoogleVertexAiErrorParser() {
        }

        @Override
        public UnifiedChatCompletionErrorResponse parse(HttpResult result) {
            return GoogleVertexAiErrorResponse.fromResponse(result);
        }

        @Override
        public UnifiedChatCompletionErrorResponse parse(String response) {
            return GoogleVertexAiErrorResponse.fromString(response);
        }
    }

    public static class GoogleVertexAiErrorResponse
    extends UnifiedChatCompletionErrorResponse {
        private static final ConstructingObjectParser<Optional<UnifiedChatCompletionErrorResponse>, Void> ERROR_PARSER = new ConstructingObjectParser("google_vertex_ai_error_wrapper", true, args -> Optional.ofNullable((GoogleVertexAiErrorResponse)args[0]));
        private static final ConstructingObjectParser<GoogleVertexAiErrorResponse, Void> ERROR_BODY_PARSER = new ConstructingObjectParser("google_vertex_ai_error_body", true, args -> new GoogleVertexAiErrorResponse((Integer)args[0], (String)args[1], (String)args[2]));

        public static UnifiedChatCompletionErrorResponse fromResponse(HttpResult response) {
            UnifiedChatCompletionErrorResponse unifiedChatCompletionErrorResponse;
            block8: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());
                try {
                    unifiedChatCompletionErrorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(UnifiedChatCompletionErrorResponse.UNDEFINED_ERROR);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        String resultAsString = new String(response.body(), StandardCharsets.UTF_8);
                        return new GoogleVertexAiErrorResponse(Strings.format((String)"Unable to parse the Google Vertex AI error, response body: [%s]", (Object[])new Object[]{resultAsString}));
                    }
                }
                parser.close();
            }
            return unifiedChatCompletionErrorResponse;
        }

        public static UnifiedChatCompletionErrorResponse fromString(String response) {
            UnifiedChatCompletionErrorResponse unifiedChatCompletionErrorResponse;
            block8: {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response);
                try {
                    unifiedChatCompletionErrorResponse = ((Optional)ERROR_PARSER.apply(parser, null)).orElse(UnifiedChatCompletionErrorResponse.UNDEFINED_ERROR);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return new GoogleVertexAiErrorResponse(Strings.format((String)"Unable to parse the Google Vertex AI error, response body: [%s]", (Object[])new Object[]{response}));
                    }
                }
                parser.close();
            }
            return unifiedChatCompletionErrorResponse;
        }

        GoogleVertexAiErrorResponse(@Nullable Integer code, String errorMessage, @Nullable String status) {
            super(errorMessage, status != null ? status : "google_vertex_ai_error", code == null ? "0" : String.valueOf(code), null);
        }

        GoogleVertexAiErrorResponse(String errorMessage) {
            super(errorMessage, "google_vertex_ai_error", null, null);
        }

        static {
            ERROR_BODY_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_CODE_FIELD, new String[0]));
            ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_MESSAGE_FIELD, new String[0]));
            ERROR_BODY_PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_STATUS_FIELD, new String[0]));
            ERROR_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_BODY_PARSER, null, new ParseField(GoogleVertexAiUnifiedChatCompletionResponseHandler.ERROR_FIELD, new String[0]));
        }
    }
}

