/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.deepseek;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class DeepSeekChatCompletionModel
extends Model {
    private static final Object RATE_LIMIT_GROUP = new Object();
    private static final RateLimitSettings RATE_LIMIT_SETTINGS = new RateLimitSettings(Integer.MAX_VALUE);
    private static final URI DEFAULT_URI = URI.create("https://api.deepseek.com/chat/completions");
    private final DeepSeekServiceSettings serviceSettings;
    @Nullable
    private final DefaultSecretSettings secretSettings;

    public static List<NamedWriteableRegistry.Entry> namedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(ServiceSettings.class, "deep_seek_service_settings", DeepSeekServiceSettings::new));
    }

    public static DeepSeekChatCompletionModel createFromNewInput(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettingsMap) {
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractRequiredString(serviceSettingsMap, "model_id", "service_settings", validationException);
        URI uri = ServiceUtils.createOptionalUri(ServiceUtils.extractOptionalString(serviceSettingsMap, "url", "service_settings", validationException));
        SecureString secureApiToken = ServiceUtils.extractRequiredSecureString(serviceSettingsMap, "api_key", "service_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        DeepSeekServiceSettings serviceSettings = new DeepSeekServiceSettings(model, uri);
        EmptyTaskSettings taskSettings = new EmptyTaskSettings();
        DefaultSecretSettings secretSettings = new DefaultSecretSettings(secureApiToken);
        ModelConfigurations modelConfigurations = new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings);
        return new DeepSeekChatCompletionModel(serviceSettings, secretSettings, modelConfigurations, new ModelSecrets((SecretSettings)secretSettings));
    }

    public static DeepSeekChatCompletionModel readFromStorage(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettingsMap, Map<String, Object> secrets) {
        ValidationException validationException = new ValidationException();
        String model = ServiceUtils.extractRequiredString(serviceSettingsMap, "model_id", "service_settings", validationException);
        URI uri = ServiceUtils.createOptionalUri(ServiceUtils.extractOptionalString(serviceSettingsMap, "url", "service_settings", validationException));
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        DeepSeekServiceSettings serviceSettings = new DeepSeekServiceSettings(model, uri);
        EmptyTaskSettings taskSettings = new EmptyTaskSettings();
        DefaultSecretSettings secretSettings = DefaultSecretSettings.fromMap(secrets);
        ModelConfigurations modelConfigurations = new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings);
        return new DeepSeekChatCompletionModel(serviceSettings, secretSettings, modelConfigurations, new ModelSecrets((SecretSettings)secretSettings));
    }

    private DeepSeekChatCompletionModel(DeepSeekServiceSettings serviceSettings, @Nullable DefaultSecretSettings secretSettings, ModelConfigurations configurations, ModelSecrets secrets) {
        super(configurations, secrets);
        this.serviceSettings = serviceSettings;
        this.secretSettings = secretSettings;
    }

    public Optional<SecureString> apiKey() {
        return Optional.ofNullable(this.secretSettings).map(DefaultSecretSettings::apiKey);
    }

    public String model() {
        return this.serviceSettings.modelId();
    }

    public URI uri() {
        return this.serviceSettings.uri() != null ? this.serviceSettings.uri() : DEFAULT_URI;
    }

    public Object rateLimitGroup() {
        return RATE_LIMIT_GROUP;
    }

    public RateLimitSettings rateLimitSettings() {
        return RATE_LIMIT_SETTINGS;
    }

    private record DeepSeekServiceSettings(String modelId, URI uri) implements ServiceSettings
    {
        private static final String NAME = "deep_seek_service_settings";
        private static final TransportVersion ML_INFERENCE_DEEPSEEK = TransportVersion.fromName((String)"ml_inference_deepseek");

        DeepSeekServiceSettings {
            Objects.requireNonNull(modelId);
        }

        DeepSeekServiceSettings(StreamInput in) throws IOException {
            this(in.readString(), (URI)in.readOptional(url -> URI.create(url.readString())));
        }

        public String getWriteableName() {
            return NAME;
        }

        public TransportVersion getMinimalSupportedVersion() {
            assert (false) : "should never be called when supportsVersion is used";
            return ML_INFERENCE_DEEPSEEK;
        }

        public boolean supportsVersion(TransportVersion version) {
            return version.supports(ML_INFERENCE_DEEPSEEK);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.modelId);
            out.writeOptionalString(this.uri != null ? this.uri.toString() : null);
        }

        public ToXContentObject getFilteredXContentObject() {
            return this;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("model_id", this.modelId);
            if (this.uri != null) {
                builder.field("url", this.uri.toString());
            }
            return builder.endObject();
        }
    }
}

