/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record AzureAiStudioEmbeddingsRequestEntity(List<String> input, InputType inputType, @Nullable String user, @Nullable Integer dimensions, boolean dimensionsSetByUser) implements ToXContentObject
{
    private static final String DOCUMENT = "document";
    private static final String QUERY = "query";
    public static final String INPUT_TYPE_FIELD = "input_type";

    public AzureAiStudioEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("input", this.input);
        if (this.user != null) {
            builder.field("user", this.user);
        }
        if (this.dimensionsSetByUser && this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (InputType.isSpecified((InputType)this.inputType)) {
            builder.field(INPUT_TYPE_FIELD, AzureAiStudioEmbeddingsRequestEntity.convertToString(this.inputType));
        }
        builder.endObject();
        return builder;
    }

    public static String convertToString(InputType inputType) {
        return switch (inputType) {
            case InputType.INGEST, InputType.INTERNAL_INGEST -> DOCUMENT;
            case InputType.SEARCH, InputType.INTERNAL_SEARCH -> QUERY;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)InputType.invalidInputTypeMessage((InputType)inputType));
                }
                yield null;
            }
        };
    }
}

