/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionTaskSettings;

public class AnthropicChatCompletionRequestEntity
implements ToXContentObject {
    private static final String MESSAGES_FIELD = "messages";
    private static final String MODEL_FIELD = "model";
    private static final String ROLE_FIELD = "role";
    private static final String USER_VALUE = "user";
    private static final String CONTENT_FIELD = "content";
    private static final String MAX_TOKENS_FIELD = "max_tokens";
    private static final String TEMPERATURE_FIELD = "temperature";
    private static final String TOP_P_FIELD = "top_p";
    private static final String TOP_K_FIELD = "top_k";
    private static final String STREAM = "stream";
    private final List<String> messages;
    private final AnthropicChatCompletionServiceSettings serviceSettings;
    private final AnthropicChatCompletionTaskSettings taskSettings;
    private final boolean stream;

    public AnthropicChatCompletionRequestEntity(List<String> messages, AnthropicChatCompletionServiceSettings serviceSettings, AnthropicChatCompletionTaskSettings taskSettings, boolean stream) {
        this.messages = Objects.requireNonNull(messages);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
        this.taskSettings = Objects.requireNonNull(taskSettings);
        this.stream = stream;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(MESSAGES_FIELD);
        for (String message : this.messages) {
            builder.startObject();
            builder.field(ROLE_FIELD, USER_VALUE);
            builder.field(CONTENT_FIELD, message);
            builder.endObject();
        }
        builder.endArray();
        builder.field(MODEL_FIELD, this.serviceSettings.modelId());
        builder.field(MAX_TOKENS_FIELD, this.taskSettings.maxTokens());
        if (this.taskSettings.temperature() != null) {
            builder.field(TEMPERATURE_FIELD, this.taskSettings.temperature());
        }
        if (this.taskSettings.topP() != null) {
            builder.field(TOP_P_FIELD, this.taskSettings.topP());
        }
        if (this.taskSettings.topK() != null) {
            builder.field(TOP_K_FIELD, this.taskSettings.topK());
        }
        if (this.stream) {
            builder.field(STREAM, true);
        }
        builder.endObject();
        return builder;
    }
}

