/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockProvider;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AmazonBedrockEmbeddingsServiceSettings
extends AmazonBedrockServiceSettings {
    public static final String NAME = "amazon_bedrock_embeddings_service_settings";
    static final String DIMENSIONS_SET_BY_USER = "dimensions_set_by_user";
    private final Integer dimensions;
    private final Boolean dimensionsSetByUser;
    private final Integer maxInputTokens;
    private final SimilarityMeasure similarity;

    public static AmazonBedrockEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        AmazonBedrockEmbeddingsServiceSettings settings = AmazonBedrockEmbeddingsServiceSettings.embeddingSettingsFromMap(map, validationException, context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return settings;
    }

    private static AmazonBedrockEmbeddingsServiceSettings embeddingSettingsFromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        AmazonBedrockServiceSettings.BaseAmazonBedrockCommonSettings baseSettings = AmazonBedrockServiceSettings.fromMap(map, validationException, context);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer maxTokens = ServiceUtils.extractOptionalPositiveInteger(map, "max_input_tokens", "service_settings", validationException);
        Integer dims = ServiceUtils.extractOptionalPositiveInteger(map, "dimensions", "service_settings", validationException);
        Boolean dimensionsSetByUser = ServiceUtils.extractOptionalBoolean(map, DIMENSIONS_SET_BY_USER, validationException);
        switch (context) {
            case REQUEST: {
                if (dimensionsSetByUser != null) {
                    validationException.addValidationError(ServiceUtils.invalidSettingError(DIMENSIONS_SET_BY_USER, "service_settings"));
                }
                if (dims != null) {
                    validationException.addValidationError(ServiceUtils.invalidSettingError("dimensions", "service_settings"));
                }
                dimensionsSetByUser = false;
                break;
            }
            case PERSISTENT: {
                if (dimensionsSetByUser != null) break;
                validationException.addValidationError(ServiceUtils.missingSettingErrorMsg(DIMENSIONS_SET_BY_USER, "service_settings"));
            }
        }
        return new AmazonBedrockEmbeddingsServiceSettings(baseSettings.region(), baseSettings.model(), baseSettings.provider(), dims, dimensionsSetByUser, maxTokens, similarity, baseSettings.rateLimitSettings());
    }

    public AmazonBedrockEmbeddingsServiceSettings(StreamInput in) throws IOException {
        super(in);
        this.dimensions = in.readOptionalVInt();
        this.dimensionsSetByUser = in.readBoolean();
        this.maxInputTokens = in.readOptionalVInt();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
    }

    public AmazonBedrockEmbeddingsServiceSettings(String region, String model, AmazonBedrockProvider provider, @Nullable Integer dimensions, Boolean dimensionsSetByUser, @Nullable Integer maxInputTokens, @Nullable SimilarityMeasure similarity, RateLimitSettings rateLimitSettings) {
        super(region, model, provider, rateLimitSettings);
        this.dimensions = dimensions;
        this.dimensionsSetByUser = dimensionsSetByUser;
        this.maxInputTokens = maxInputTokens;
        this.similarity = similarity;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalVInt(this.dimensions);
        out.writeBoolean(this.dimensionsSetByUser.booleanValue());
        out.writeOptionalVInt(this.maxInputTokens);
        out.writeOptionalEnum((Enum)this.similarity);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.addBaseXContent(builder, params);
        builder.field(DIMENSIONS_SET_BY_USER, this.dimensionsSetByUser);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addXContentFragmentOfExposedFields(builder, params);
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        return builder;
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Boolean dimensionsSetByUser() {
        return this.dimensionsSetByUser;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonBedrockEmbeddingsServiceSettings that = (AmazonBedrockEmbeddingsServiceSettings)o;
        return Objects.equals(this.region, that.region) && Objects.equals((Object)this.provider, (Object)that.provider) && Objects.equals(this.model, that.model) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.dimensionsSetByUser, that.dimensionsSetByUser) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.region, this.model, this.provider, this.dimensions, this.dimensionsSetByUser, this.maxInputTokens, this.similarity, this.rateLimitSettings});
    }
}

