/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.instrumentation;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.entitlement.instrumentation.Instrumenter;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class Transformer
implements ClassFileTransformer {
    private static final Logger logger = LogManager.getLogger(Transformer.class);
    private final Instrumenter instrumenter;
    private final Set<String> classesToTransform;
    private final AtomicBoolean hadErrors = new AtomicBoolean(false);
    private boolean verifyClasses;

    public Transformer(Instrumenter instrumenter, Set<String> classesToTransform, boolean verifyClasses) {
        this.instrumenter = instrumenter;
        this.classesToTransform = classesToTransform;
        this.verifyClasses = verifyClasses;
    }

    public void enableClassVerification() {
        this.verifyClasses = true;
    }

    public boolean hadErrors() {
        return this.hadErrors.get();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (this.classesToTransform.contains(className)) {
            logger.debug("Transforming " + className);
            try {
                return this.instrumenter.instrumentClass(className, classfileBuffer, this.verifyClasses);
            }
            catch (Throwable t) {
                this.hadErrors.set(true);
                logger.error("Failed to instrument class " + className, t);
                return null;
            }
        }
        return null;
    }
}

