/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.io.IOException;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.util.AttributeSource;
import org.elasticsearch.analysis.common.AnalysisPredicateScript;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;

public class PredicateTokenFilterScriptFactory
extends AbstractTokenFilterFactory {
    private final AnalysisPredicateScript.Factory factory;

    public PredicateTokenFilterScriptFactory(IndexSettings indexSettings, String name, Settings settings, ScriptService scriptService) {
        super(name);
        Settings scriptSettings = settings.getAsSettings("script");
        Script script = Script.parse((Settings)scriptSettings);
        if (script.getType() != ScriptType.INLINE) {
            throw new IllegalArgumentException("Cannot use stored scripts in tokenfilter [" + name + "]");
        }
        this.factory = (AnalysisPredicateScript.Factory)scriptService.compile(script, AnalysisPredicateScript.CONTEXT);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ScriptFilteringTokenFilter(tokenStream, this.factory.newInstance());
    }

    private static class ScriptFilteringTokenFilter
    extends FilteringTokenFilter {
        final AnalysisPredicateScript script;
        final AnalysisPredicateScript.Token token;

        ScriptFilteringTokenFilter(TokenStream in, AnalysisPredicateScript script) {
            super(in);
            this.script = script;
            this.token = new AnalysisPredicateScript.Token((AttributeSource)this);
        }

        protected boolean accept() throws IOException {
            this.token.updatePosition();
            return this.script.execute(this.token);
        }

        public void reset() throws IOException {
            super.reset();
            this.token.reset();
        }
    }
}

