/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.connector.ConnectorIndexService;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorFeaturesAction;

public class TransportUpdateConnectorFeaturesAction
extends HandledTransportAction<UpdateConnectorFeaturesAction.Request, ConnectorUpdateActionResponse> {
    protected final ConnectorIndexService connectorIndexService;

    @Inject
    public TransportUpdateConnectorFeaturesAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/xpack/connector/update_features", transportService, actionFilters, UpdateConnectorFeaturesAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.connectorIndexService = new ConnectorIndexService(client);
    }

    protected void doExecute(Task task, UpdateConnectorFeaturesAction.Request request, ActionListener<ConnectorUpdateActionResponse> listener) {
        this.connectorIndexService.updateConnectorFeatures(request.getConnectorId(), request.getFeatures(), (ActionListener<UpdateResponse>)listener.map(r -> new ConnectorUpdateActionResponse(r.getResult())));
    }
}

