/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;
import org.elasticsearch.xpack.core.downsample.DownsampleShardPersistentTaskState;
import org.elasticsearch.xpack.core.downsample.DownsampleShardTask;
import org.elasticsearch.xpack.downsample.DownsampleMetrics;
import org.elasticsearch.xpack.downsample.DownsampleShardIndexer;
import org.elasticsearch.xpack.downsample.DownsampleShardIndexerException;
import org.elasticsearch.xpack.downsample.DownsampleShardTaskParams;

public class DownsampleShardPersistentTaskExecutor
extends PersistentTasksExecutor<DownsampleShardTaskParams> {
    private static final Logger LOGGER = LogManager.getLogger(DownsampleShardPersistentTaskExecutor.class);
    private final Client client;
    private final boolean isStateless;

    public DownsampleShardPersistentTaskExecutor(Client client, String taskName, Settings settings, Executor executor) {
        super(taskName, executor);
        this.client = Objects.requireNonNull(client);
        this.isStateless = DiscoveryNode.isStateless((Settings)settings);
    }

    protected void nodeOperation(AllocatedPersistentTask task, DownsampleShardTaskParams params, PersistentTaskState state) {
        SearchRequest searchRequest = new SearchRequest(new String[]{params.downsampleIndex()});
        searchRequest.source().sort("_tsid", SortOrder.DESC).size(1);
        searchRequest.preference("_shards:" + params.shardId().id());
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> this.delegate(task, params, DownsampleShardPersistentTaskExecutor.extractTsId(searchResponse.getHits().getHits())), e -> this.delegate(task, params, null)));
    }

    private static BytesRef extractTsId(SearchHit[] lastDownsampleTsidHits) {
        if (lastDownsampleTsidHits.length == 0) {
            return null;
        }
        SearchHit searchHit = Arrays.stream(lastDownsampleTsidHits).findFirst().get();
        DocumentField field = searchHit.field("_tsid");
        return field != null ? (BytesRef)field.getValue() : null;
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<DownsampleShardTaskParams> taskInProgress, Map<String, String> headers) {
        DownsampleShardTaskParams params = (DownsampleShardTaskParams)taskInProgress.getParams();
        return new DownsampleShardTask(id, type, action, parentTaskId, params.downsampleIndex(), params.indexStartTimeMillis(), params.indexEndTimeMillis(), params.downsampleConfig(), headers, params.shardId());
    }

    public void validate(DownsampleShardTaskParams params, ClusterState clusterState, @Nullable ProjectId projectId) {
        IndexShardRoutingTable indexShardRouting = DownsampleShardPersistentTaskExecutor.findShardRoutingTable(params.shardId(), clusterState);
        if (indexShardRouting == null) {
            throw new ShardNotFoundException(params.shardId());
        }
    }

    protected PersistentTasksCustomMetadata.Assignment doGetAssignment(DownsampleShardTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState, @Nullable ProjectId projectId) {
        ShardId shardId = params.shardId();
        IndexShardRoutingTable indexShardRouting = DownsampleShardPersistentTaskExecutor.findShardRoutingTable(shardId, clusterState);
        if (indexShardRouting == null) {
            DiscoveryNode node = this.selectLeastLoadedNode(clusterState, candidateNodes, DiscoveryNode::canContainData);
            return new PersistentTasksCustomMetadata.Assignment(node.getId(), "a node to fail and stop this persistent task");
        }
        return indexShardRouting.activeShards().stream().filter(this::isEligible).map(ShardRouting::currentNodeId).filter(nodeId -> this.isCandidateNode(candidateNodes, (String)nodeId)).findAny().map(nodeId -> new PersistentTasksCustomMetadata.Assignment(nodeId, "downsampling using node holding shard [" + String.valueOf(shardId) + "]")).orElse(NO_NODE_FOUND);
    }

    private boolean isEligible(ShardRouting shardRouting) {
        return shardRouting.started() && (this.isStateless ? shardRouting.isSearchable() : shardRouting.primary());
    }

    private boolean isCandidateNode(Collection<DiscoveryNode> candidateNodes, String nodeId) {
        for (DiscoveryNode candidateNode : candidateNodes) {
            if (!candidateNode.getId().equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    public Executor getExecutor() {
        return EsExecutors.DIRECT_EXECUTOR_SERVICE;
    }

    private void delegate(AllocatedPersistentTask task, DownsampleShardTaskParams params, BytesRef lastDownsampleTsid) {
        DownsampleShardTask downsampleShardTask = (DownsampleShardTask)task;
        this.client.execute((ActionType)DelegatingAction.INSTANCE, (ActionRequest)new DelegatingAction.Request(downsampleShardTask, lastDownsampleTsid, params), ActionListener.wrap(empty -> {}, e -> {
            LOGGER.error("error while delegating", (Throwable)e);
            DownsampleShardPersistentTaskExecutor.markAsFailed(downsampleShardTask, e);
        }));
    }

    private static IndexShardRoutingTable findShardRoutingTable(ShardId shardId, ClusterState clusterState) {
        Optional indexRoutingTable = clusterState.globalRoutingTable().indexRouting(clusterState.metadata(), shardId.getIndex());
        return indexRoutingTable.map(routingTable -> routingTable.shard(shardId.getId())).orElse(null);
    }

    static void realNodeOperation(final Client client, final IndicesService indicesService, final DownsampleMetrics downsampleMetrics, final DownsampleShardTask task, final DownsampleShardTaskParams params, final BytesRef lastDownsampledTsid) {
        client.threadPool().executor("downsample_indexing").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                DownsampleShardPersistentTaskExecutor.markAsFailed(task, e);
            }

            protected void doRun() throws Exception {
                DownsampleShardPersistentTaskState initialState = new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.INITIALIZED, lastDownsampledTsid);
                try {
                    DownsampleShardIndexer downsampleShardIndexer = new DownsampleShardIndexer(task, client, indicesService.indexServiceSafe(params.shardId().getIndex()), downsampleMetrics, params.shardId(), params.downsampleIndex(), params.downsampleConfig(), params.metrics(), params.labels(), params.dimensions(), params.multiFieldSources() == null ? Map.of() : params.multiFieldSources(), initialState);
                    downsampleShardIndexer.execute();
                    task.markAsCompleted();
                }
                catch (DownsampleShardIndexerException e) {
                    if (e.isRetriable()) {
                        LOGGER.warn("Downsampling task [" + task.getPersistentTaskId() + " retriable failure [" + e.getMessage() + "]");
                        task.markAsLocallyAborted(e.getMessage());
                    } else {
                        LOGGER.error("Downsampling task [" + task.getPersistentTaskId() + " non retriable failure [" + e.getMessage() + "]");
                        DownsampleShardPersistentTaskExecutor.markAsFailed(task, (Exception)((Object)e));
                    }
                }
                catch (IndexNotFoundException e) {
                    LOGGER.error("Downsampling task [" + task.getPersistentTaskId() + " failing because source index not assigned");
                    DownsampleShardPersistentTaskExecutor.markAsFailed(task, (Exception)((Object)e));
                }
                catch (Exception e) {
                    LOGGER.error("Downsampling task [" + task.getPersistentTaskId() + " non-retriable failure [" + e.getMessage() + "]");
                    DownsampleShardPersistentTaskExecutor.markAsFailed(task, e);
                }
            }
        });
    }

    private static void markAsFailed(DownsampleShardTask task, Exception e) {
        task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.FAILED);
        task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.FAILED, null), ActionListener.running(() -> task.markAsFailed(e)));
    }

    public static class DelegatingAction
    extends ActionType<ActionResponse.Empty> {
        public static final DelegatingAction INSTANCE = new DelegatingAction();
        public static final String NAME = "indices:data/read/downsample_delegate";

        private DelegatingAction() {
            super(NAME);
        }

        public static class TA
        extends TransportAction<Request, ActionResponse.Empty> {
            private final Client client;
            private final IndicesService indicesService;
            private final DownsampleMetrics downsampleMetrics;

            @Inject
            public TA(TransportService transportService, ActionFilters actionFilters, Client client, IndicesService indicesService, DownsampleMetrics downsampleMetrics) {
                super(DelegatingAction.NAME, actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
                this.client = client;
                this.indicesService = indicesService;
                this.downsampleMetrics = downsampleMetrics;
            }

            protected void doExecute(Task t, Request request, ActionListener<ActionResponse.Empty> listener) {
                DownsampleShardPersistentTaskExecutor.realNodeOperation(this.client, this.indicesService, this.downsampleMetrics, request.task, request.params, request.lastDownsampleTsid);
                listener.onResponse((Object)ActionResponse.Empty.INSTANCE);
            }
        }

        public static class Request
        extends LegacyActionRequest
        implements IndicesRequest.RemoteClusterShardRequest {
            private final DownsampleShardTask task;
            private final BytesRef lastDownsampleTsid;
            private final DownsampleShardTaskParams params;

            public Request(DownsampleShardTask task, BytesRef lastDownsampleTsid, DownsampleShardTaskParams params) {
                this.task = task;
                this.lastDownsampleTsid = lastDownsampleTsid;
                this.params = params;
            }

            public ActionRequestValidationException validate() {
                return null;
            }

            public String[] indices() {
                return new String[]{this.params.shardId().getIndexName()};
            }

            public IndicesOptions indicesOptions() {
                return IndicesOptions.STRICT_EXPAND_OPEN;
            }

            public void writeTo(StreamOutput out) {
                throw new IllegalStateException("request should stay local");
            }

            public Collection<ShardId> shards() {
                return Collections.singletonList(this.task.shardId());
            }
        }
    }
}

