/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.array.operation.ApplyCholesky;
import org.ojalgo.array.operation.ApplyLDL;
import org.ojalgo.array.operation.ApplyLU;
import org.ojalgo.array.operation.FillMatchingDual;
import org.ojalgo.array.operation.FillMatchingSingle;
import org.ojalgo.array.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.array.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.array.operation.HouseholderHermitian;
import org.ojalgo.array.operation.ModifyAll;
import org.ojalgo.array.operation.OperationBinary;
import org.ojalgo.array.operation.OperationUnary;
import org.ojalgo.array.operation.RotateLeft;
import org.ojalgo.array.operation.RotateRight;
import org.ojalgo.array.operation.SubstituteBackwards;
import org.ojalgo.array.operation.SubstituteForwards;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.operation.HouseholderLeft;
import org.ojalgo.matrix.operation.HouseholderRight;
import org.ojalgo.matrix.operation.MultiplyBoth;
import org.ojalgo.matrix.operation.MultiplyLeft;
import org.ojalgo.matrix.operation.MultiplyNeither;
import org.ojalgo.matrix.operation.MultiplyRight;
import org.ojalgo.matrix.store.ConjugatedStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Subregion2D;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

public final class GenericStore<N extends Scalar<N>>
extends ScalarArray<N>
implements PhysicalStore<N>,
DecompositionStore<N> {
    public static final PhysicalStore.Factory<ComplexNumber, GenericStore<ComplexNumber>> COMPLEX = new Factory<ComplexNumber>(ComplexArray.FACTORY);
    public static final PhysicalStore.Factory<Quaternion, GenericStore<Quaternion>> QUATERNION = new Factory<Quaternion>(QuaternionArray.FACTORY);
    public static final PhysicalStore.Factory<RationalNumber, GenericStore<RationalNumber>> RATIONAL = new Factory<RationalNumber>(RationalArray.FACTORY);
    private final MultiplyBoth.Generic<N> multiplyBoth;
    private final MultiplyLeft.Generic<N> multiplyLeft;
    private final MultiplyNeither.Generic<N> multiplyNeither;
    private final MultiplyRight.Generic<N> multiplyRight;
    private final int myColDim;
    private final Factory<N> myFactory;
    private final int myRowDim;
    private final Array2D<N> myUtility;
    private transient N[] myWorkerColumn;

    public static <N extends Scalar<N>> GenericStore<N> wrap(Factory<N> factory, N ... data) {
        return new GenericStore(factory, data.length, 1, data);
    }

    public static <N extends Scalar<N>> GenericStore<N> wrap(Factory<N> factory, N[] data, int structure) {
        return new GenericStore(factory, structure, data.length / structure, data);
    }

    private GenericStore(Factory<N> factory, int numbRows) {
        this(factory, numbRows, 1);
    }

    private GenericStore(Factory<N> factory, N[] dataArray) {
        this(factory, dataArray.length, 1, (Scalar[])dataArray);
    }

    GenericStore(Factory<N> factory, int numbRows, int numbCols) {
        super(factory.array(), numbRows * numbCols);
        this.myFactory = factory;
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.newGeneric(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.newGeneric(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.newGeneric(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.newGeneric(this.myRowDim, this.myColDim);
    }

    GenericStore(Factory<N> factory, int numbRows, int numbCols, N[] dataArray) {
        super(factory.array(), dataArray);
        this.myFactory = factory;
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.newGeneric(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.newGeneric(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.newGeneric(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.newGeneric(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<?> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, (Comparable<?>)supplied.get(i, j));
            }
        }
    }

    @Override
    public void add(long row, long col, Comparable<?> addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public void applyCholesky(int iterationPoint, BasicArray<N> multipliers) {
        final Scalar[] tmpData = (Scalar[])this.data;
        final Scalar[] tmpColumn = (Scalar[])((ScalarArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyCholesky.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyCholesky.invoke((Scalar[])tmpData, (int)GenericStore.this.myRowDim, (int)aFirst, (int)aLimit, (Scalar[])tmpColumn);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyCholesky.THRESHOLD);
        } else {
            ApplyCholesky.invoke((Scalar[])tmpData, (int)this.myRowDim, (int)(iterationPoint + 1), (int)this.myColDim, (Scalar[])tmpColumn);
        }
    }

    @Override
    public void applyLDL(final int iterationPoint, BasicArray<N> multipliers) {
        final Scalar[] tmpData = (Scalar[])this.data;
        final Scalar[] tmpColumn = (Scalar[])((ScalarArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLDL.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLDL.invoke((Scalar[])tmpData, (int)GenericStore.this.myRowDim, (int)first, (int)limit, (Scalar[])tmpColumn, (int)iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLDL.THRESHOLD);
        } else {
            ApplyLDL.invoke((Scalar[])tmpData, (int)this.myRowDim, (int)(iterationPoint + 1), (int)this.myColDim, (Scalar[])tmpColumn, (int)iterationPoint);
        }
    }

    @Override
    public void applyLU(final int iterationPoint, BasicArray<N> multipliers) {
        final Scalar[] tmpData = (Scalar[])this.data;
        final Scalar[] tmpColumn = (Scalar[])((ScalarArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLU.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyLU.invoke((Scalar[])tmpData, (int)GenericStore.this.myRowDim, (int)aFirst, (int)aLimit, (Scalar[])tmpColumn, (int)iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLU.THRESHOLD);
        } else {
            ApplyLU.invoke((Scalar[])tmpData, (int)this.myRowDim, (int)(iterationPoint + 1), (int)this.myColDim, (Scalar[])tmpColumn, (int)iterationPoint);
        }
    }

    @Override
    public Array1D<N> asList() {
        return this.myUtility.flatten();
    }

    @Override
    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<N> transformationCollector, boolean eigenvalue) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return null;
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new ConjugatedStore(this);
    }

    @Override
    public GenericStore<N> copy() {
        return new GenericStore(this.myFactory, this.myRowDim, this.myColDim, (Scalar[])this.copyOfData());
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public void divideAndCopyColumn(int row, int column, BasicArray<N> destination) {
        Scalar[] tmpData = (Scalar[])this.data;
        int tmpRowDim = this.myRowDim;
        Scalar[] tmpDestination = (Scalar[])((ScalarArray)destination).data;
        int tmpIndex = row + column * tmpRowDim;
        Scalar tmpDenominator = tmpData[tmpIndex];
        for (int i = row + 1; i < tmpRowDim; ++i) {
            tmpDestination[i] = tmpData[tmpIndex] = (Scalar)tmpData[++tmpIndex].divide(tmpDenominator).get();
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.doubleValue(row + col * (long)this.myRowDim);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof GenericStore)) {
            return false;
        }
        GenericStore other = (GenericStore)obj;
        if (this.myColDim != other.myColDim) {
            return false;
        }
        if (this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory)) {
            return false;
        }
        return this.myRowDim == other.myRowDim;
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeHermitian(int indexA, int indexB) {
        Comparable tmpVal;
        int tmpMin = Math.min(indexA, indexB);
        int tmpMax = Math.max(indexA, indexB);
        for (int j = 0; j < tmpMin; ++j) {
            tmpVal = this.get(tmpMin, j);
            this.set((long)tmpMin, (long)j, this.get(tmpMax, j));
            this.set((long)tmpMax, (long)j, tmpVal);
        }
        tmpVal = this.get(tmpMin, tmpMin);
        this.set((long)tmpMin, (long)tmpMin, this.get(tmpMax, tmpMax));
        this.set((long)tmpMax, (long)tmpMax, tmpVal);
        for (int ij = tmpMin + 1; ij < tmpMax; ++ij) {
            tmpVal = this.get(ij, tmpMin);
            this.set((long)ij, (long)tmpMin, (Comparable)((Scalar)this.get(tmpMax, ij).conjugate()).get());
            this.set((long)tmpMax, (long)ij, (Comparable)((Scalar)tmpVal.conjugate()).get());
        }
        for (int i = tmpMax + 1; i < this.myRowDim; ++i) {
            tmpVal = this.get(i, tmpMin);
            this.set((long)i, (long)tmpMin, this.get(i, tmpMax));
            this.set((long)i, (long)tmpMax, tmpVal);
        }
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
        int complexity = Math.toIntExact(left.count() / this.countRows());
        if (complexity != Math.toIntExact(right.count() / this.countColumns())) {
            ProgrammingError.throwForMultiplicationNotPossible();
        }
        if (left instanceof GenericStore) {
            if (right instanceof GenericStore) {
                this.multiplyNeither.invoke((Scalar[])this.data, (Scalar[])this.cast(left).data, complexity, (Scalar[])this.cast(right).data, this.myFactory.scalar());
            } else {
                this.multiplyRight.invoke((Scalar[])this.data, (Scalar[])this.cast(left).data, complexity, right, this.myFactory.scalar());
            }
        } else if (right instanceof GenericStore) {
            this.multiplyLeft.invoke((Scalar[])this.data, left, complexity, (Scalar[])this.cast(right).data, this.myFactory.scalar());
        } else {
            this.multiplyBoth.invoke((TransformableRegion<N>)this, left, complexity, right);
        }
    }

    @Override
    public void fillColumn(long row, long col, Access1D<N> values) {
        this.myUtility.fillColumn(row, col, values);
    }

    @Override
    public void fillColumn(long row, long col, N value) {
        this.myUtility.fillColumn(row, col, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillColumn(row, col, supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, N value) {
        this.myUtility.fillDiagonal(row, col, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillDiagonal(row, col, supplier);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        if (values instanceof ConjugatedStore) {
            final ConjugatedStore conjugated = (ConjugatedStore)values;
            if (this.myColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.conjugate((Scalar[])((Scalar[])GenericStore.this.data), (int)GenericStore.this.myRowDim, (int)first, (int)limit, conjugated.getOriginal(), GenericStore.this.myFactory.scalar());
                    }
                };
                tmpConquerer.invoke(0, this.myColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.conjugate((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)0, (int)this.myColDim, conjugated.getOriginal(), this.myFactory.scalar());
            }
        } else if (values instanceof TransposedStore) {
            final TransposedStore transposed = (TransposedStore)values;
            if (this.myColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.transpose((Scalar[])((Scalar[])GenericStore.this.data), (int)GenericStore.this.myRowDim, (int)first, (int)limit, transposed.getOriginal(), GenericStore.this.myFactory.scalar());
                    }
                };
                tmpConquerer.invoke(0, this.myColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)0, (int)this.myColDim, transposed.getOriginal(), this.myFactory.scalar());
            }
        } else {
            super.fillMatching(values);
        }
    }

    @Override
    public void fillMatching(final Access1D<N> left, final BinaryFunction<N> function, final Access1D<N> right) {
        int matchingCount = MissingMath.toMinIntExact(this.count(), left.count(), right.count());
        if (this.myColDim > FillMatchingDual.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    OperationBinary.invoke((Comparable[])GenericStore.this.data, (int)first, (int)limit, (int)1, (Access1D)left, (BinaryFunction)function, (Access1D)right);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingDual.THRESHOLD * FillMatchingDual.THRESHOLD);
        } else {
            OperationBinary.invoke((Comparable[])this.data, (int)0, (int)matchingCount, (int)1, left, function, right);
        }
    }

    @Override
    public void fillMatching(final UnaryFunction<N> function, final Access1D<N> arguments) {
        int matchingCount = MissingMath.toMinIntExact(this.count(), arguments.count());
        if (this.myColDim > FillMatchingSingle.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    OperationUnary.invoke((Comparable[])GenericStore.this.data, (int)first, (int)limit, (int)1, (Access1D)arguments, (UnaryFunction)function);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingSingle.THRESHOLD * FillMatchingSingle.THRESHOLD);
        } else {
            OperationUnary.invoke((Comparable[])this.data, (int)0, (int)matchingCount, (int)1, arguments, function);
        }
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, (Comparable<?>)values.get(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, N value) {
        this.myUtility.fillOne(row, col, value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillOne(row, col, supplier);
    }

    @Override
    public void fillRow(long row, long col, Access1D<N> values) {
        this.myUtility.fillRow(row, col, values);
    }

    @Override
    public void fillRow(long row, long col, N value) {
        this.myUtility.fillRow(row, col, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<?> supplier) {
        this.myUtility.fillRow(row, col, supplier);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderColumn(int row, int column, Householder<N> destination) {
        return GenerateApplyAndCopyHouseholderColumn.invoke((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)row, (int)column, (Householder.Generic)((Householder.Generic)destination), this.myFactory.scalar());
    }

    @Override
    public boolean generateApplyAndCopyHouseholderRow(int row, int column, Householder<N> destination) {
        return GenerateApplyAndCopyHouseholderRow.invoke((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)row, (int)column, (Householder.Generic)((Householder.Generic)destination), this.myFactory.scalar());
    }

    @Override
    public MatrixStore<N> get() {
        return this;
    }

    @Override
    public N get(long row, long col) {
        return (N)((Scalar)this.myUtility.get(row, col));
    }

    @Override
    public int getColDim() {
        return this.myColDim;
    }

    @Override
    public int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    @Override
    public int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    @Override
    public int getRowDim() {
        return this.myRowDim;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.myColDim;
        result = 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
        result = 31 * result + this.myRowDim;
        return result;
    }

    @Override
    public long indexOfLargest() {
        return this.myUtility.indexOfLargest();
    }

    @Override
    public void modifyAll(final UnaryFunction<N> modifier) {
        final int numberOfRows = this.myRowDim;
        int numberOfCols = this.myColDim;
        if (numberOfCols > ModifyAll.THRESHOLD) {
            DivideAndConquer conquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    GenericStore.this.modify(numberOfRows * aFirst, numberOfRows * aLimit, 1, modifier);
                }
            };
            conquerer.invoke(0, numberOfCols, ModifyAll.THRESHOLD);
        } else {
            this.modify(0, numberOfRows * numberOfCols, 1, modifier);
        }
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
        this.myUtility.modifyColumn(row, col, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
        this.myUtility.modifyDiagonal(row, col, modifier);
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        Comparable tmpValue = this.get(row, col);
        tmpValue = (Scalar)modifier.invoke(tmpValue);
        this.set(row, col, tmpValue);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
        this.myUtility.modifyRow(row, col, modifier);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        GenericStore retVal = (GenericStore)this.physical().make((long)this.myRowDim, right.count() / (long)this.myColDim);
        if (right instanceof GenericStore) {
            retVal.multiplyNeither.invoke((Scalar[])retVal.data, (Scalar[])this.data, this.myColDim, (Scalar[])this.cast(right).data, this.myFactory.scalar());
        } else {
            retVal.multiplyRight.invoke((Scalar[])retVal.data, (Scalar[])this.data, this.myColDim, right, this.myFactory.scalar());
        }
        return retVal;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        Structure2D tmpStep1 = this.myFactory.make(1L, leftAndRight.count());
        Structure2D tmpStep2 = this.myFactory.make(1L, 1L);
        Structure2D tmpLeft = this.myFactory.rows(new Access1D[]{leftAndRight});
        tmpLeft.modifyAll(this.myFactory.function().conjugate());
        tmpStep1.fillByMultiplying(tmpLeft, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (N)((Scalar)tmpStep2.get(0L));
    }

    @Override
    public void negateColumn(int column) {
        this.myUtility.modifyColumn(0L, column, this.myFactory.function().negate());
    }

    @Override
    public PhysicalStore.Factory<N, GenericStore<N>> physical() {
        return this.myFactory;
    }

    @Override
    public TransformableRegion<N> regionByColumns(int ... columns) {
        return new Subregion2D.ColumnsRegion<N>(this, this.multiplyBoth, columns);
    }

    @Override
    public TransformableRegion<N> regionByLimits(int rowLimit, int columnLimit) {
        return new Subregion2D.LimitRegion<N>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public TransformableRegion<N> regionByOffsets(int rowOffset, int columnOffset) {
        return new Subregion2D.OffsetRegion<N>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public TransformableRegion<N> regionByRows(int ... rows) {
        return new Subregion2D.RowsRegion<N>(this, this.multiplyBoth, rows);
    }

    @Override
    public TransformableRegion<N> regionByTransposing() {
        return new Subregion2D.TransposedRegion<N>(this, this.multiplyBoth);
    }

    @Override
    public void rotateRight(int low, int high, double cos, double sin) {
        RotateRight.invoke((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)low, (int)high, (Scalar)((Scalar)this.myFactory.scalar().cast(cos)), (Scalar)((Scalar)this.myFactory.scalar().cast(sin)));
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void setToIdentity(int col) {
        this.myUtility.set((long)col, (long)col, (Comparable)this.myFactory.scalar().one().get());
        this.myUtility.fillColumn((long)(col + 1), (long)col, (Comparable)this.myFactory.scalar().zero().get());
    }

    @Override
    public Array1D<N> sliceColumn(long row, long col) {
        return this.myUtility.sliceColumn(row, col);
    }

    @Override
    public Array1D<N> sliceDiagonal(long row, long col) {
        return this.myUtility.sliceDiagonal(row, col);
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return this.myUtility.sliceRange(first, limit);
    }

    @Override
    public Array1D<N> sliceRow(long row, long col) {
        return this.myUtility.sliceRow(row, col);
    }

    @Override
    public void substituteBackwards(final Access2D<N> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteBackwards.invoke((Scalar[])((Scalar[])GenericStore.this.data), (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)hermitian, GenericStore.this.myFactory.scalar());
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke((Scalar[])((Scalar[])this.data), (int)tmpRowDim, (int)0, (int)tmpColDim, body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)hermitian, this.myFactory.scalar());
        }
    }

    @Override
    public void substituteForwards(final Access2D<N> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteForwards.invoke((Scalar[])((Scalar[])GenericStore.this.data), (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)identity, GenericStore.this.myFactory.scalar());
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke((Scalar[])((Scalar[])this.data), (int)tmpRowDim, (int)0, (int)tmpColDim, body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)identity, this.myFactory.scalar());
        }
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return (Scalar)this.myUtility.get(row, column);
    }

    @Override
    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void transformLeft(Householder<N> transformation, int firstColumn) {
        HouseholderLeft.call((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)firstColumn, this.cast(transformation), this.myFactory.scalar());
    }

    @Override
    public void transformLeft(Rotation<N> transformation) {
        Rotation.Generic<N> tmpTransf = this.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateLeft.invoke((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)tmpLow, (int)tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyRow(tmpLow, 0L, this.myFactory.function().multiply().second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyRow(tmpLow, 0L, this.myFactory.function().divide().second(tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, this.myFactory.function().negate());
        }
    }

    @Override
    public void transformRight(Householder<N> transformation, int firstRow) {
        HouseholderRight.call((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)firstRow, this.cast(transformation), this.myFactory.scalar());
    }

    @Override
    public void transformRight(Rotation<N> transformation) {
        Rotation.Generic<N> tmpTransf = this.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateRight.invoke((Scalar[])((Scalar[])this.data), (int)this.myRowDim, (int)tmpLow, (int)tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, this.myFactory.function().multiply().second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, this.myFactory.function().divide().second(tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, this.myFactory.function().negate());
        }
    }

    @Override
    public void transformSymmetric(Householder<N> transformation) {
        HouseholderHermitian.invoke((Scalar[])((Scalar[])this.data), this.cast(transformation), (Scalar[])this.getWorkerColumn(), this.myFactory.scalar());
    }

    @Override
    public MatrixStore<N> transpose() {
        return new TransposedStore(this);
    }

    @Override
    public void tred2(BasicArray<N> mainDiagonal, BasicArray<N> offDiagonal, boolean yesvecs) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<N> visitor) {
        this.myUtility.visitColumn(row, col, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<N> visitor) {
        this.myUtility.visitDiagonal(row, col, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<N> visitor) {
        this.myUtility.visitRow(row, col, visitor);
    }

    private GenericStore<N> cast(Access1D<N> matrix) {
        if (matrix instanceof GenericStore) {
            return (GenericStore)matrix;
        }
        if (matrix instanceof Access2D) {
            return this.myFactory.copy((Access2D)matrix);
        }
        return this.myFactory.columns(new Access1D[]{matrix});
    }

    private Householder.Generic<N> cast(Householder<N> transformation) {
        if (transformation instanceof Householder.Generic) {
            return (Householder.Generic)transformation;
        }
        if (transformation instanceof HouseholderReference) {
            return ((Householder.Generic)((HouseholderReference)transformation).getWorker(this.myFactory)).copy(transformation);
        }
        return new Householder.Generic<N>(this.myFactory.scalar(), transformation);
    }

    private Rotation.Generic<N> cast(Rotation<N> transformation) {
        if (transformation instanceof Rotation.Generic) {
            return (Rotation.Generic)transformation;
        }
        return new Rotation.Generic<N>(transformation);
    }

    private N[] getWorkerColumn() {
        if (this.myWorkerColumn == null) {
            this.myWorkerColumn = (Scalar[])this.myFactory.scalar().newArrayInstance(this.myRowDim);
        }
        Arrays.fill(this.myWorkerColumn, this.myFactory.scalar().zero().get());
        return this.myWorkerColumn;
    }

    static final class Factory<N extends Scalar<N>>
    implements PhysicalStore.Factory<N, GenericStore<N>> {
        private final DenseArray.Factory<N> myDenseArrayFactory;

        Factory(DenseArray.Factory<N> denseArrayFactory) {
            this.myDenseArrayFactory = denseArrayFactory;
        }

        @Override
        public AggregatorSet<N> aggregator() {
            return this.myDenseArrayFactory.function().aggregator();
        }

        @Override
        public DenseArray.Factory<N> array() {
            return this.myDenseArrayFactory;
        }

        @Override
        public GenericStore<N> columns(Access1D<?> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast((Comparable<?>)tmpColumn.get(i));
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericStore<N> columns(Comparable<?>[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                Comparable<?>[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast(tmpColumn[i]);
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericStore<N> columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast(tmpColumn[i]);
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericStore<N> columns(List<? extends Comparable<?>> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                List<Comparable<?>> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast(tmpColumn.get(i));
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericStore<N> conjugate(final Access2D<?> source) {
            final GenericStore retVal = new GenericStore(this, (int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.conjugate((Scalar[])((Scalar[])retVal.data), (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)source, this.scalar());
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.conjugate((Scalar[])((Scalar[])retVal.data), (int)tmpRowDim, (int)0, (int)tmpColDim, source, this.scalar());
            }
            return retVal;
        }

        @Override
        public GenericStore<N> copy(final Access2D<?> source) {
            final int tmpRowDim = source.getRowDim();
            int tmpColDim = source.getColDim();
            final GenericStore retVal = new GenericStore(this, tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.copy((Scalar[])((Scalar[])retVal.data), (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)source, this.scalar());
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.copy((Scalar[])((Scalar[])retVal.data), (int)tmpRowDim, (int)0, (int)tmpColDim, source, this.scalar());
            }
            return retVal;
        }

        @Override
        public FunctionSet<N> function() {
            return this.myDenseArrayFactory.function();
        }

        @Override
        public GenericStore<N> make(long rows, long columns) {
            return new GenericStore(this, (int)rows, (int)columns);
        }

        @Override
        public Householder.Generic<N> makeHouseholder(int length) {
            return new Householder.Generic(this.myDenseArrayFactory.scalar(), length);
        }

        @Override
        public Rotation.Generic<N> makeRotation(int low, int high, double cos, double sin) {
            return this.makeRotation(low, high, (N)((Scalar)this.myDenseArrayFactory.scalar().cast(cos)), (N)((Scalar)this.myDenseArrayFactory.scalar().cast(sin)));
        }

        @Override
        public Rotation.Generic<N> makeRotation(int low, int high, N cos, N sin) {
            return new Rotation.Generic<N>(low, high, cos, sin);
        }

        @Override
        public GenericStore<N> rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast((Comparable<?>)tmpRow.get(j));
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericStore<N> rows(Comparable<?>[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                Comparable<?>[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast(tmpRow[j]);
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericStore<N> rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast(tmpRow[j]);
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericStore<N> rows(List<? extends Comparable<?>> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            Scalar[] tmpData = (Scalar[])this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                List<Comparable<?>> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = (Scalar)this.myDenseArrayFactory.scalar().cast(tmpRow.get(j));
                }
            }
            return new GenericStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Scalar.Factory<N> scalar() {
            return this.myDenseArrayFactory.scalar();
        }

        @Override
        public GenericStore<N> transpose(final Access2D<?> source) {
            final GenericStore retVal = new GenericStore(this, (int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.transpose((Scalar[])((Scalar[])retVal.data), (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)source, this.scalar());
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose((Scalar[])((Scalar[])retVal.data), (int)tmpRowDim, (int)0, (int)tmpColDim, source, this.scalar());
            }
            return retVal;
        }
    }
}

