/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.ann;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.ojalgo.ann.ArtificialNeuralNetwork;
import org.ojalgo.ann.LayerTemplate;
import org.ojalgo.matrix.store.PhysicalStore;

public final class NetworkBuilder
implements Supplier<ArtificialNeuralNetwork> {
    private final PhysicalStore.Factory<Double, ?> myFactory;
    private final List<LayerTemplate> myLayers = new ArrayList<LayerTemplate>();
    private int myNextInputs = 0;

    NetworkBuilder(PhysicalStore.Factory<Double, ?> factory, int networkInputs) {
        this.myFactory = factory;
        this.myNextInputs = networkInputs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NetworkBuilder)) {
            return false;
        }
        NetworkBuilder other = (NetworkBuilder)obj;
        if (this.myNextInputs != other.myNextInputs) {
            return false;
        }
        if (this.myFactory == null ? other.myFactory != null : !this.myFactory.equals(other.myFactory)) {
            return false;
        }
        return this.myLayers.equals(other.myLayers);
    }

    @Override
    public ArtificialNeuralNetwork get() {
        ArtificialNeuralNetwork network = new ArtificialNeuralNetwork(this);
        network.randomise();
        return network;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myFactory == null ? 0 : this.myFactory.hashCode());
        result = 31 * result + this.myLayers.hashCode();
        result = 31 * result + this.myNextInputs;
        return result;
    }

    public NetworkBuilder layer(int outputs) {
        return this.layer(outputs, ArtificialNeuralNetwork.Activator.SIGMOID);
    }

    public NetworkBuilder layer(int outputs, ArtificialNeuralNetwork.Activator activator) {
        this.myLayers.add(new LayerTemplate(this.myNextInputs, outputs, activator));
        this.myNextInputs = outputs;
        return this;
    }

    PhysicalStore.Factory<Double, ?> getFactory() {
        return this.myFactory;
    }

    List<LayerTemplate> getLayers() {
        return this.myLayers;
    }
}

