/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.user;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.function.Predicate;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.authz.privilege.SystemPrivilege;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.InternalUsers;
import org.elasticsearch.xpack.core.security.user.User;

public class SystemUser
extends InternalUser {
    public static final String NAME = "_system";
    @Deprecated
    public static final String ROLE_NAME = "_system";
    private static final RoleDescriptor REMOTE_ACCESS_ROLE_DESCRIPTOR = new RoleDescriptor("_system_cross_cluster_access", new String[]{"cross_cluster_search", "cross_cluster_replication"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("cross_cluster_replication", "cross_cluster_replication_internal").allowRestrictedIndices(true).build()}, null, null, null, null, null, null, null, null, null);
    static final SystemUser INSTANCE = new SystemUser();
    private static final Predicate<String> PREDICATE = SystemPrivilege.INSTANCE.predicate();

    private SystemUser() {
        super("_system", Optional.empty(), Optional.of(REMOTE_ACCESS_ROLE_DESCRIPTOR));
    }

    @Override
    public Optional<RoleDescriptor> getLocalClusterRoleDescriptor() {
        return Optional.empty();
    }

    @Deprecated
    public static boolean is(User user) {
        return InternalUsers.SYSTEM_USER.equals(user);
    }

    public static boolean isAuthorized(String action) {
        return PREDICATE.test(action);
    }

    public static CrossClusterAccessSubjectInfo crossClusterAccessSubjectInfo(TransportVersion transportVersion, String nodeName) {
        try {
            return new CrossClusterAccessSubjectInfo(Authentication.newInternalAuthentication(INSTANCE, transportVersion, nodeName), RoleDescriptorsIntersection.EMPTY);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

