/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissionGroup;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public class RoleDescriptor
implements ToXContentObject,
Writeable {
    public static final TransportVersion WORKFLOWS_RESTRICTION_VERSION = TransportVersions.V_8_9_X;
    public static final TransportVersion SECURITY_ROLE_DESCRIPTION = TransportVersions.V_8_15_0;
    public static final String ROLE_TYPE = "role";
    private static final Logger logger = LogManager.getLogger(RoleDescriptor.class);
    private final String name;
    private final String[] clusterPrivileges;
    private final ConfigurableClusterPrivilege[] configurableClusterPrivileges;
    private final IndicesPrivileges[] indicesPrivileges;
    private final ApplicationResourcePrivileges[] applicationPrivileges;
    private final String[] runAs;
    private final RemoteIndicesPrivileges[] remoteIndicesPrivileges;
    private final RemoteClusterPermissions remoteClusterPermissions;
    private final Restriction restriction;
    private final Map<String, Object> metadata;
    private final Map<String, Object> transientMetadata;
    private final String description;
    private static FieldPermissionsCache fieldPermissionsCache = new FieldPermissionsCache(Settings.EMPTY);

    public static synchronized void setFieldPermissionsCache(FieldPermissionsCache cache) {
        fieldPermissionsCache = Objects.requireNonNull(cache);
    }

    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable String[] runAs) {
        this(name, clusterPrivileges, indicesPrivileges, runAs, null);
    }

    @Deprecated
    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable String[] runAs, @Nullable Map<String, Object> metadata) {
        this(name, clusterPrivileges, indicesPrivileges, runAs, metadata, null);
    }

    @Deprecated
    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable String[] runAs, @Nullable Map<String, Object> metadata, @Nullable Map<String, Object> transientMetadata) {
        this(name, clusterPrivileges, indicesPrivileges, null, null, runAs, metadata, transientMetadata, RemoteIndicesPrivileges.NONE, RemoteClusterPermissions.NONE, Restriction.NONE, null);
    }

    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable ApplicationResourcePrivileges[] applicationPrivileges, @Nullable ConfigurableClusterPrivilege[] configurableClusterPrivileges, @Nullable String[] runAs, @Nullable Map<String, Object> metadata, @Nullable Map<String, Object> transientMetadata) {
        this(name, clusterPrivileges, indicesPrivileges, applicationPrivileges, configurableClusterPrivileges, runAs, metadata, transientMetadata, RemoteIndicesPrivileges.NONE, RemoteClusterPermissions.NONE, Restriction.NONE, null);
    }

    public RoleDescriptor(String name, @Nullable String[] clusterPrivileges, @Nullable IndicesPrivileges[] indicesPrivileges, @Nullable ApplicationResourcePrivileges[] applicationPrivileges, @Nullable ConfigurableClusterPrivilege[] configurableClusterPrivileges, @Nullable String[] runAs, @Nullable Map<String, Object> metadata, @Nullable Map<String, Object> transientMetadata, @Nullable RemoteIndicesPrivileges[] remoteIndicesPrivileges, @Nullable RemoteClusterPermissions remoteClusterPermissions, @Nullable Restriction restriction, @Nullable String description) {
        this.name = name;
        this.clusterPrivileges = clusterPrivileges != null ? clusterPrivileges : Strings.EMPTY_ARRAY;
        this.configurableClusterPrivileges = RoleDescriptor.sortConfigurableClusterPrivileges(configurableClusterPrivileges);
        this.indicesPrivileges = indicesPrivileges != null ? indicesPrivileges : IndicesPrivileges.NONE;
        this.applicationPrivileges = applicationPrivileges != null ? applicationPrivileges : ApplicationResourcePrivileges.NONE;
        this.runAs = runAs != null ? runAs : Strings.EMPTY_ARRAY;
        this.metadata = metadata != null ? Collections.unmodifiableMap(metadata) : Collections.emptyMap();
        this.transientMetadata = transientMetadata != null ? Collections.unmodifiableMap(transientMetadata) : Collections.singletonMap("enabled", true);
        this.remoteIndicesPrivileges = remoteIndicesPrivileges != null ? remoteIndicesPrivileges : RemoteIndicesPrivileges.NONE;
        this.remoteClusterPermissions = remoteClusterPermissions != null && remoteClusterPermissions.hasAnyPrivileges() ? remoteClusterPermissions : RemoteClusterPermissions.NONE;
        this.restriction = restriction != null ? restriction : Restriction.NONE;
        this.description = description != null ? description : "";
    }

    public RoleDescriptor(StreamInput in) throws IOException {
        this.name = in.readString();
        this.clusterPrivileges = in.readStringArray();
        int size = in.readVInt();
        this.indicesPrivileges = new IndicesPrivileges[size];
        for (int i = 0; i < size; ++i) {
            this.indicesPrivileges[i] = new IndicesPrivileges(in);
        }
        this.runAs = in.readStringArray();
        this.metadata = in.readGenericMap();
        this.transientMetadata = in.readGenericMap();
        this.applicationPrivileges = (ApplicationResourcePrivileges[])in.readArray(ApplicationResourcePrivileges::new, ApplicationResourcePrivileges[]::new);
        this.configurableClusterPrivileges = ConfigurableClusterPrivileges.readArray(in);
        this.remoteIndicesPrivileges = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0) ? (RemoteIndicesPrivileges[])in.readArray(RemoteIndicesPrivileges::new, RemoteIndicesPrivileges[]::new) : RemoteIndicesPrivileges.NONE;
        this.restriction = in.getTransportVersion().onOrAfter((VersionId)WORKFLOWS_RESTRICTION_VERSION) ? new Restriction(in) : Restriction.NONE;
        this.remoteClusterPermissions = in.getTransportVersion().onOrAfter((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS) ? new RemoteClusterPermissions(in) : RemoteClusterPermissions.NONE;
        this.description = in.getTransportVersion().onOrAfter((VersionId)SECURITY_ROLE_DESCRIPTION) ? in.readOptionalString() : "";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public ConfigurableClusterPrivilege[] getConditionalClusterPrivileges() {
        return this.configurableClusterPrivileges;
    }

    public IndicesPrivileges[] getIndicesPrivileges() {
        return this.indicesPrivileges;
    }

    public RemoteIndicesPrivileges[] getRemoteIndicesPrivileges() {
        return this.remoteIndicesPrivileges;
    }

    public boolean hasRemoteIndicesPrivileges() {
        return this.remoteIndicesPrivileges.length != 0;
    }

    public boolean hasRemoteClusterPermissions() {
        return this.remoteClusterPermissions.hasAnyPrivileges();
    }

    public RemoteClusterPermissions getRemoteClusterPermissions() {
        return this.remoteClusterPermissions;
    }

    public ApplicationResourcePrivileges[] getApplicationPrivileges() {
        return this.applicationPrivileges;
    }

    public boolean hasClusterPrivileges() {
        return this.clusterPrivileges.length != 0;
    }

    public boolean hasApplicationPrivileges() {
        return this.applicationPrivileges.length != 0;
    }

    public boolean hasConfigurableClusterPrivileges() {
        return this.configurableClusterPrivileges.length != 0;
    }

    public boolean hasRunAs() {
        return this.runAs.length != 0;
    }

    public boolean hasDescription() {
        return this.description.length() != 0;
    }

    public boolean hasUnsupportedPrivilegesInsideAPIKeyConnectedRemoteCluster() {
        return this.hasConfigurableClusterPrivileges() || this.hasApplicationPrivileges() || this.hasRunAs() || this.hasRemoteIndicesPrivileges() || this.hasRemoteClusterPermissions() || this.hasWorkflowsRestriction() || this.hasClusterPrivileges() && !RemoteClusterPermissions.getSupportedRemoteClusterPermissions().containsAll(Arrays.asList(this.clusterPrivileges));
    }

    public String[] getRunAs() {
        return this.runAs;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public boolean hasRestriction() {
        return this.restriction != null && false == this.restriction.isEmpty();
    }

    public boolean hasWorkflowsRestriction() {
        return this.hasRestriction() && this.restriction.hasWorkflows();
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Map<String, Object> getTransientMetadata() {
        return this.transientMetadata;
    }

    public boolean isUsingDocumentOrFieldLevelSecurity() {
        return Arrays.stream(this.indicesPrivileges).anyMatch(ip -> ip.isUsingDocumentLevelSecurity() || ip.isUsingFieldLevelSecurity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Role[");
        sb.append("name=").append(this.name);
        sb.append(", cluster=[").append(Strings.arrayToCommaDelimitedString((Object[])this.clusterPrivileges));
        sb.append("], global=[").append(Strings.arrayToCommaDelimitedString((Object[])this.configurableClusterPrivileges));
        sb.append("], indicesPrivileges=[");
        for (IndicesPrivileges indicesPrivileges : this.indicesPrivileges) {
            sb.append(indicesPrivileges.toString()).append(",");
        }
        sb.append("], applicationPrivileges=[");
        for (ApplicationResourcePrivileges applicationResourcePrivileges : this.applicationPrivileges) {
            sb.append(applicationResourcePrivileges.toString()).append(",");
        }
        sb.append("], runAs=[").append(Strings.arrayToCommaDelimitedString((Object[])this.runAs));
        sb.append("], metadata=[");
        sb.append(this.metadata);
        sb.append("]");
        sb.append(", remoteIndicesPrivileges=[");
        for (RemoteIndicesPrivileges remoteIndicesPrivileges : this.remoteIndicesPrivileges) {
            sb.append(remoteIndicesPrivileges.toString()).append(",");
        }
        sb.append("], remoteClusterPrivileges=[");
        for (RemoteClusterPermissionGroup group : this.remoteClusterPermissions.groups()) {
            sb.append(group.toString()).append(",");
        }
        sb.append("], restriction=").append(this.restriction);
        sb.append(", description=").append(this.description);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleDescriptor that = (RoleDescriptor)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.clusterPrivileges, that.clusterPrivileges)) {
            return false;
        }
        if (!Arrays.equals(this.configurableClusterPrivileges, that.configurableClusterPrivileges)) {
            return false;
        }
        if (!Arrays.equals(this.indicesPrivileges, that.indicesPrivileges)) {
            return false;
        }
        if (!Arrays.equals(this.applicationPrivileges, that.applicationPrivileges)) {
            return false;
        }
        if (!this.metadata.equals(that.getMetadata())) {
            return false;
        }
        if (!Arrays.equals(this.runAs, that.runAs)) {
            return false;
        }
        if (!Arrays.equals(this.remoteIndicesPrivileges, that.remoteIndicesPrivileges)) {
            return false;
        }
        if (!this.remoteClusterPermissions.equals(that.remoteClusterPermissions)) {
            return false;
        }
        if (!this.restriction.equals(that.restriction)) {
            return false;
        }
        return Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.clusterPrivileges);
        result = 31 * result + Arrays.hashCode(this.configurableClusterPrivileges);
        result = 31 * result + Arrays.hashCode(this.indicesPrivileges);
        result = 31 * result + Arrays.hashCode(this.applicationPrivileges);
        result = 31 * result + Arrays.hashCode(this.runAs);
        result = 31 * result + this.metadata.hashCode();
        result = 31 * result + Arrays.hashCode(this.remoteIndicesPrivileges);
        result = 31 * result + this.remoteClusterPermissions.hashCode();
        result = 31 * result + this.restriction.hashCode();
        result = 31 * result + Objects.hashCode(this.description);
        return result;
    }

    public boolean isEmpty() {
        return this.clusterPrivileges.length == 0 && this.configurableClusterPrivileges.length == 0 && this.indicesPrivileges.length == 0 && this.applicationPrivileges.length == 0 && this.runAs.length == 0 && this.metadata.size() == 0 && this.remoteIndicesPrivileges.length == 0 && this.remoteClusterPermissions.groups().isEmpty() && this.restriction.isEmpty();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean docCreation) throws IOException {
        builder.startObject();
        this.innerToXContent(builder, params, docCreation);
        return builder.endObject();
    }

    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params, boolean docCreation) throws IOException {
        builder.array(Fields.CLUSTER.getPreferredName(), this.clusterPrivileges);
        if (this.configurableClusterPrivileges.length != 0) {
            builder.field(Fields.GLOBAL.getPreferredName());
            ConfigurableClusterPrivileges.toXContent(builder, params, Arrays.asList(this.configurableClusterPrivileges));
        }
        builder.xContentList(Fields.INDICES.getPreferredName(), (ToXContent[])this.indicesPrivileges);
        builder.xContentList(Fields.APPLICATIONS.getPreferredName(), (ToXContent[])this.applicationPrivileges);
        if (this.runAs != null) {
            builder.array(Fields.RUN_AS.getPreferredName(), this.runAs);
        }
        builder.field(Fields.METADATA.getPreferredName(), this.metadata);
        if (docCreation) {
            builder.field(Fields.TYPE.getPreferredName(), ROLE_TYPE);
        } else {
            builder.field(Fields.TRANSIENT_METADATA.getPreferredName(), this.transientMetadata);
        }
        if (this.hasRemoteIndicesPrivileges()) {
            builder.xContentList(Fields.REMOTE_INDICES.getPreferredName(), (ToXContent[])this.remoteIndicesPrivileges);
        }
        if (this.hasRemoteClusterPermissions()) {
            builder.array(Fields.REMOTE_CLUSTER.getPreferredName(), new Object[]{this.remoteClusterPermissions});
        }
        if (this.hasRestriction()) {
            builder.field(Fields.RESTRICTION.getPreferredName(), (ToXContent)this.restriction);
        }
        if (this.hasDescription()) {
            builder.field(Fields.DESCRIPTION.getPreferredName(), this.description);
        }
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.clusterPrivileges);
        out.writeVInt(this.indicesPrivileges.length);
        for (IndicesPrivileges group : this.indicesPrivileges) {
            group.writeTo(out);
        }
        out.writeStringArray(this.runAs);
        out.writeGenericMap(this.metadata);
        out.writeGenericMap(this.transientMetadata);
        out.writeArray(ApplicationResourcePrivileges::write, (Object[])this.applicationPrivileges);
        ConfigurableClusterPrivileges.writeArray(out, this.getConditionalClusterPrivileges());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0)) {
            out.writeArray((Writeable[])this.remoteIndicesPrivileges);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)WORKFLOWS_RESTRICTION_VERSION)) {
            this.restriction.writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS)) {
            this.remoteClusterPermissions.writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)SECURITY_ROLE_DESCRIPTION)) {
            out.writeOptionalString(this.description);
        }
    }

    public static Parser.Builder parserBuilder() {
        return new Parser.Builder();
    }

    private static String[] readStringArray(String roleName, XContentParser parser, boolean allowNull) throws IOException {
        try {
            return XContentUtils.readStringArray(parser, allowNull);
        }
        catch (ElasticsearchParseException e) {
            throw new ElasticsearchParseException("failed to parse role [{}]", (Throwable)e, new Object[]{roleName});
        }
    }

    public static AuthorizationEngine.PrivilegesToCheck parsePrivilegesToCheck(String description, boolean runDetailedCheck, XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse privileges check [{}]. expected an object but found [{}] instead", new Object[]{description, parser.currentToken()});
        }
        String currentFieldName = null;
        IndicesPrivileges[] indexPrivileges = null;
        String[] clusterPrivileges = null;
        ApplicationResourcePrivileges[] applicationPrivileges = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Fields.INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                indexPrivileges = RoleDescriptor.parseIndices(description, parser, false);
                continue;
            }
            if (Fields.CLUSTER.match(currentFieldName, parser.getDeprecationHandler())) {
                clusterPrivileges = RoleDescriptor.readStringArray(description, parser, true);
                continue;
            }
            if (Fields.APPLICATIONS.match(currentFieldName, parser.getDeprecationHandler()) || Fields.APPLICATION.match(currentFieldName, parser.getDeprecationHandler())) {
                applicationPrivileges = RoleDescriptor.parseApplicationPrivileges(description, parser);
                continue;
            }
            throw new ElasticsearchParseException("failed to parse privileges check [{}]. unexpected field [{}]", new Object[]{description, currentFieldName});
        }
        if (indexPrivileges == null && clusterPrivileges == null && applicationPrivileges == null) {
            throw new ElasticsearchParseException("failed to parse privileges check [{}]. All privilege fields [{},{},{}] are missing", new Object[]{description, Fields.CLUSTER, Fields.INDEX, Fields.APPLICATIONS});
        }
        if (indexPrivileges != null) {
            if (Arrays.stream(indexPrivileges).anyMatch(IndicesPrivileges::isUsingFieldLevelSecurity)) {
                throw new ElasticsearchParseException("Field [{}] is not supported in a has_privileges request", new Object[]{Fields.FIELD_PERMISSIONS});
            }
            if (Arrays.stream(indexPrivileges).anyMatch(IndicesPrivileges::isUsingDocumentLevelSecurity)) {
                throw new ElasticsearchParseException("Field [{}] is not supported in a has_privileges request", new Object[]{Fields.QUERY});
            }
        }
        return new AuthorizationEngine.PrivilegesToCheck(clusterPrivileges != null ? clusterPrivileges : Strings.EMPTY_ARRAY, indexPrivileges != null ? indexPrivileges : IndicesPrivileges.NONE, applicationPrivileges != null ? applicationPrivileges : ApplicationResourcePrivileges.NONE, runDetailedCheck);
    }

    public static AuthorizationEngine.PrivilegesToCheck parsePrivilegesToCheck(String description, boolean runDetailedCheck, BytesReference source, XContentType xContentType) throws IOException {
        try (XContentParser parser = RoleDescriptor.createParser(source, xContentType);){
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse privileges check [{}]. expected an object but found [{}] instead", new Object[]{description, token});
            }
            AuthorizationEngine.PrivilegesToCheck privilegesToCheck = RoleDescriptor.parsePrivilegesToCheck(description, runDetailedCheck, parser);
            return privilegesToCheck;
        }
    }

    private static XContentParser createParser(BytesReference source, XContentType xContentType) throws IOException {
        return XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)source, (XContentType)xContentType);
    }

    public static IndicesPrivileges[] parseIndices(String roleName, XContentParser parser, boolean allow2xFormat) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be an array, but found [{}] instead", new Object[]{roleName, parser.currentName(), parser.currentToken()});
        }
        ArrayList<IndicesPrivileges> privileges = new ArrayList<IndicesPrivileges>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            privileges.add(RoleDescriptor.parseIndex(roleName, parser, allow2xFormat));
        }
        return privileges.toArray(new IndicesPrivileges[privileges.size()]);
    }

    private static IndicesPrivileges parseIndex(String roleName, XContentParser parser, boolean allow2xFormat) throws IOException {
        IndicesPrivilegesWithOptionalRemoteClusters parsed = RoleDescriptor.parseIndexWithOptionalRemoteClusters(roleName, parser, allow2xFormat, false);
        assert (parsed.remoteClusters() == null) : "indices privileges cannot have remote clusters";
        return parsed.indicesPrivileges();
    }

    private static RemoteIndicesPrivileges[] parseRemoteIndices(String roleName, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("failed to parse remote indices privileges for role [{}]. expected field [{}] value to be an array, but found [{}] instead", new Object[]{roleName, parser.currentName(), parser.currentToken()});
        }
        ArrayList<RemoteIndicesPrivileges> privileges = new ArrayList<RemoteIndicesPrivileges>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            privileges.add(RoleDescriptor.parseRemoteIndex(roleName, parser));
        }
        return privileges.toArray(new RemoteIndicesPrivileges[0]);
    }

    private static RemoteIndicesPrivileges parseRemoteIndex(String roleName, XContentParser parser) throws IOException {
        IndicesPrivilegesWithOptionalRemoteClusters parsed = RoleDescriptor.parseIndexWithOptionalRemoteClusters(roleName, parser, false, true);
        if (parsed.remoteClusters() == null) {
            throw new ElasticsearchParseException("failed to parse remote indices privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.CLUSTERS});
        }
        return new RemoteIndicesPrivileges(parsed.indicesPrivileges(), parsed.remoteClusters());
    }

    private static RemoteClusterPermissions parseRemoteCluster(String roleName, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("failed to parse remote_cluster for role [{}]. expected field [{}] value to be an array, but found [{}] instead", new Object[]{roleName, parser.currentName(), parser.currentToken()});
        }
        RemoteClusterPermissions remoteClusterPermissions = new RemoteClusterPermissions();
        Object[] privileges = null;
        String[] clusters = null;
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Fields.PRIVILEGES.match(currentFieldName, parser.getDeprecationHandler())) {
                    privileges = RoleDescriptor.readStringArray(roleName, parser, false);
                    if (Arrays.stream(privileges).map(s -> s.toLowerCase(Locale.ROOT).trim()).allMatch(RemoteClusterPermissions.getSupportedRemoteClusterPermissions()::contains)) continue;
                    String message = String.format(Locale.ROOT, "failed to parse remote_cluster for role [%s]. %s are the only values allowed for [%s] within [remote_cluster]. Found %s", roleName, RemoteClusterPermissions.getSupportedRemoteClusterPermissions(), currentFieldName, Arrays.toString(privileges));
                    logger.info(message);
                    throw new ElasticsearchParseException(message, new Object[0]);
                }
                if (Fields.CLUSTERS.match(currentFieldName, parser.getDeprecationHandler())) {
                    clusters = RoleDescriptor.readStringArray(roleName, parser, false);
                    continue;
                }
                String message = String.format(Locale.ROOT, "failed to parse remote_cluster for role [%s]. unexpected field [%s]", roleName, currentFieldName);
                logger.info(message);
                throw new ElasticsearchParseException(message, new Object[0]);
            }
            if (privileges != null && clusters == null) {
                throw new ElasticsearchParseException("failed to parse remote_cluster for role [{}]. [clusters] must be defined when [privileges] are defined ", new Object[]{roleName});
            }
            if (privileges == null && clusters != null) {
                throw new ElasticsearchParseException("failed to parse remote_cluster for role [{}]. [privileges] must be defined when [clusters] are defined ", new Object[]{roleName});
            }
            remoteClusterPermissions.addGroup(new RemoteClusterPermissionGroup((String[])privileges, clusters));
        }
        return remoteClusterPermissions;
    }

    public static IndicesPrivileges parseIndexWithPredefinedPrivileges(String roleName, String[] privileges, XContentParser parser) throws IOException {
        IndicesPrivilegesWithOptionalRemoteClusters indicesPrivilegesWithOptionalRemoteClusters = RoleDescriptor.parseIndexWithOptionalRemoteClusters(roleName, parser, false, false, privileges);
        assert (indicesPrivilegesWithOptionalRemoteClusters.remoteClusters == null);
        return indicesPrivilegesWithOptionalRemoteClusters.indicesPrivileges;
    }

    private static IndicesPrivilegesWithOptionalRemoteClusters parseIndexWithOptionalRemoteClusters(String roleName, XContentParser parser, boolean allow2xFormat, boolean allowRemoteClusters) throws IOException {
        return RoleDescriptor.parseIndexWithOptionalRemoteClusters(roleName, parser, allow2xFormat, allowRemoteClusters, null);
    }

    private static IndicesPrivilegesWithOptionalRemoteClusters parseIndexWithOptionalRemoteClusters(String roleName, XContentParser parser, boolean allow2xFormat, boolean allowRemoteClusters, String[] predefinedPrivileges) throws IOException {
        assert (predefinedPrivileges == null || predefinedPrivileges.length != 0);
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be an array of objects, but found an array element of type [{}]", new Object[]{roleName, parser.currentName(), token});
        }
        String currentFieldName = null;
        String[] names = null;
        BytesReference query = null;
        String[] privileges = predefinedPrivileges;
        String[] grantedFields = null;
        String[] deniedFields = null;
        boolean allowRestrictedIndices = false;
        String[] remoteClusters = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Fields.NAMES.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    names = new String[]{parser.text()};
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    names = RoleDescriptor.readStringArray(roleName, parser, false);
                    if (names.length != 0) continue;
                    throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. [{}] cannot be an empty array", new Object[]{roleName, currentFieldName});
                }
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be a string or an array of strings, but found [{}] instead", new Object[]{roleName, currentFieldName, token});
            }
            if (Fields.ALLOW_RESTRICTED_INDICES.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_BOOLEAN) {
                    allowRestrictedIndices = parser.booleanValue();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be a boolean, but found [{}] instead", new Object[]{roleName, currentFieldName, token});
            }
            if (Fields.QUERY.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = JsonXContent.contentBuilder();
                    builder.generator().copyCurrentStructure(parser);
                    query = BytesReference.bytes((XContentBuilder)builder);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    String text = parser.text();
                    if (text.isEmpty()) continue;
                    query = new BytesArray(text);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NULL) continue;
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected field [{}] value to be null, a string, an array, or an object, but found [{}] instead", new Object[]{roleName, currentFieldName, token});
            }
            if (Fields.FIELD_PERMISSIONS.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.START_OBJECT) {
                    token = parser.nextToken();
                    do {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            if (Fields.GRANT_FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                                parser.nextToken();
                                grantedFields = RoleDescriptor.readStringArray(roleName, parser, true);
                                if (grantedFields != null) continue;
                                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. {} must not be null.", new Object[]{roleName, Fields.GRANT_FIELDS});
                            }
                            if (Fields.EXCEPT_FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                                parser.nextToken();
                                deniedFields = RoleDescriptor.readStringArray(roleName, parser, true);
                                if (deniedFields != null) continue;
                                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. {} must not be null.", new Object[]{roleName, Fields.EXCEPT_FIELDS});
                            }
                            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. \"{}\" only accepts options {} and {}, but got: {}", new Object[]{roleName, Fields.FIELD_PERMISSIONS, Fields.GRANT_FIELDS, Fields.EXCEPT_FIELDS, parser.currentName()});
                        }
                        if (token == XContentParser.Token.END_OBJECT) {
                            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. \"{}\" must not be empty.", new Object[]{roleName, Fields.FIELD_PERMISSIONS});
                        }
                        throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected {} but got {}.", new Object[]{roleName, XContentParser.Token.FIELD_NAME, token});
                    } while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT);
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. expected {} but got {} in \"{}\".", new Object[]{roleName, XContentParser.Token.START_OBJECT, token, Fields.FIELD_PERMISSIONS});
            }
            if (Fields.PRIVILEGES.match(currentFieldName, parser.getDeprecationHandler())) {
                if (privileges == null) {
                    privileges = RoleDescriptor.readStringArray(roleName, parser, true);
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. field [{}] must not present", new Object[]{roleName, Fields.PRIVILEGES.getPreferredName()});
            }
            if (Fields.FIELD_PERMISSIONS_2X.match(currentFieldName, parser.getDeprecationHandler())) {
                if (allow2xFormat) {
                    grantedFields = RoleDescriptor.readStringArray(roleName, parser, true);
                    continue;
                }
                throw new ElasticsearchParseException("[\"fields\": [...]] format has changed for field permissions in role [{}], use [\"{}\": {\"{}\":[...],\"{}\":[...]}] instead", new Object[]{roleName, Fields.FIELD_PERMISSIONS, Fields.GRANT_FIELDS, Fields.EXCEPT_FIELDS, roleName});
            }
            if (Fields.TRANSIENT_METADATA.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.START_OBJECT) {
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                    }
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse transient metadata for role [{}]. expected {} but got {} in \"{}\".", new Object[]{roleName, XContentParser.Token.START_OBJECT, token, Fields.TRANSIENT_METADATA});
            }
            if (allowRemoteClusters && Fields.CLUSTERS.match(currentFieldName, parser.getDeprecationHandler())) {
                remoteClusters = RoleDescriptor.readStringArray(roleName, parser, false);
                continue;
            }
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. unexpected field [{}]", new Object[]{roleName, currentFieldName});
        }
        if (names == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.NAMES.getPreferredName()});
        }
        if (privileges == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.PRIVILEGES.getPreferredName()});
        }
        if (deniedFields != null && grantedFields == null) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}]. {} requires {} if {} is given", new Object[]{roleName, Fields.FIELD_PERMISSIONS, Fields.GRANT_FIELDS, Fields.EXCEPT_FIELDS});
        }
        RoleDescriptor.checkIfExceptFieldsIsSubsetOfGrantedFields(roleName, grantedFields, deniedFields);
        return new IndicesPrivilegesWithOptionalRemoteClusters(IndicesPrivileges.builder().indices(names).privileges(privileges).grantedFields(grantedFields).deniedFields(deniedFields).query(query).allowRestrictedIndices(allowRestrictedIndices).build(), remoteClusters);
    }

    private static ConfigurableClusterPrivilege[] sortConfigurableClusterPrivileges(ConfigurableClusterPrivilege[] configurableClusterPrivileges) {
        if (null == configurableClusterPrivileges) {
            return ConfigurableClusterPrivileges.EMPTY_ARRAY;
        }
        if (configurableClusterPrivileges.length < 2) {
            return configurableClusterPrivileges;
        }
        ConfigurableClusterPrivilege[] configurableClusterPrivilegesCopy = Arrays.copyOf(configurableClusterPrivileges, configurableClusterPrivileges.length);
        Arrays.sort(configurableClusterPrivilegesCopy, Comparator.comparingInt(o -> o.getCategory().ordinal()));
        return configurableClusterPrivilegesCopy;
    }

    private static void checkIfExceptFieldsIsSubsetOfGrantedFields(String roleName, String[] grantedFields, String[] deniedFields) {
        try {
            fieldPermissionsCache.getFieldPermissions(new FieldPermissionsDefinition(grantedFields, deniedFields));
        }
        catch (ElasticsearchSecurityException e) {
            throw new ElasticsearchParseException("failed to parse indices privileges for role [{}] - {}", (Throwable)e, new Object[]{roleName, e.getMessage()});
        }
    }

    public static ApplicationResourcePrivileges[] parseApplicationPrivileges(String roleName, XContentParser parser) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("failed to parse application privileges for role [{}]. expected field [{}] value to be an array, but found [{}] instead", new Object[]{roleName, parser.currentName(), parser.currentToken()});
        }
        ArrayList<ApplicationResourcePrivileges> privileges = new ArrayList<ApplicationResourcePrivileges>();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            privileges.add(RoleDescriptor.parseApplicationPrivilege(roleName, parser));
        }
        return privileges.toArray(new ApplicationResourcePrivileges[privileges.size()]);
    }

    private static ApplicationResourcePrivileges parseApplicationPrivilege(String roleName, XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse application privileges for role [{}]. expected field [{}] value to be an array of objects, but found an array element of type [{}]", new Object[]{roleName, parser.currentName(), token});
        }
        ApplicationResourcePrivileges.Builder builder = (ApplicationResourcePrivileges.Builder)ApplicationResourcePrivileges.PARSER.parse(parser, null);
        if (!builder.hasResources()) {
            throw new ElasticsearchParseException("failed to parse application privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.RESOURCES.getPreferredName()});
        }
        if (!builder.hasPrivileges()) {
            throw new ElasticsearchParseException("failed to parse application privileges for role [{}]. missing required [{}] field", new Object[]{roleName, Fields.PRIVILEGES.getPreferredName()});
        }
        return builder.build();
    }

    public static class IndicesPrivileges
    implements ToXContentObject,
    Writeable,
    Comparable<IndicesPrivileges> {
        private static final IndicesPrivileges[] NONE = new IndicesPrivileges[0];
        private String[] indices;
        private String[] privileges;
        private String[] grantedFields = null;
        private String[] deniedFields = null;
        private BytesReference query;
        private boolean allowRestrictedIndices = false;

        private IndicesPrivileges() {
        }

        public IndicesPrivileges(StreamInput in) throws IOException {
            this.indices = in.readStringArray();
            this.grantedFields = in.readOptionalStringArray();
            this.deniedFields = in.readOptionalStringArray();
            this.privileges = in.readStringArray();
            this.query = in.readOptionalBytesReference();
            this.allowRestrictedIndices = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.indices);
            out.writeOptionalStringArray(this.grantedFields);
            out.writeOptionalStringArray(this.deniedFields);
            out.writeStringArray(this.privileges);
            out.writeOptionalBytesReference(this.query);
            out.writeBoolean(this.allowRestrictedIndices);
        }

        public static Builder builder() {
            return new Builder();
        }

        public String[] getIndices() {
            return this.indices;
        }

        public String[] getPrivileges() {
            return this.privileges;
        }

        @Nullable
        public String[] getGrantedFields() {
            return this.grantedFields;
        }

        @Nullable
        public String[] getDeniedFields() {
            return this.deniedFields;
        }

        @Nullable
        public BytesReference getQuery() {
            return this.query;
        }

        public boolean isUsingDocumentLevelSecurity() {
            return this.query != null;
        }

        public boolean isUsingFieldLevelSecurity() {
            return this.hasDeniedFields() || this.hasGrantedFields();
        }

        public boolean isUsingDocumentOrFieldLevelSecurity() {
            return this.isUsingDocumentLevelSecurity() || this.isUsingFieldLevelSecurity();
        }

        public boolean allowRestrictedIndices() {
            return this.allowRestrictedIndices;
        }

        public boolean hasDeniedFields() {
            return this.deniedFields != null && this.deniedFields.length > 0;
        }

        public boolean hasGrantedFields() {
            if (this.grantedFields != null && this.grantedFields.length >= 0) {
                return this.grantedFields.length != 1 || !"*".equals(this.grantedFields[0]);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IndicesPrivileges[");
            sb.append("indices=[").append(Strings.arrayToCommaDelimitedString((Object[])this.indices));
            sb.append("], allowRestrictedIndices=[").append(this.allowRestrictedIndices);
            sb.append("], privileges=[").append(Strings.arrayToCommaDelimitedString((Object[])this.privileges));
            sb.append("], ");
            if (this.grantedFields != null || this.deniedFields != null) {
                sb.append(Fields.FIELD_PERMISSIONS).append("=[");
                if (this.grantedFields == null) {
                    sb.append(Fields.GRANT_FIELDS).append("=null");
                } else {
                    sb.append(Fields.GRANT_FIELDS).append("=[").append(Strings.arrayToCommaDelimitedString((Object[])this.grantedFields));
                    sb.append("]");
                }
                if (this.deniedFields == null) {
                    sb.append(", ").append(Fields.EXCEPT_FIELDS).append("=null");
                } else {
                    sb.append(", ").append(Fields.EXCEPT_FIELDS).append("=[").append(Strings.arrayToCommaDelimitedString((Object[])this.deniedFields));
                    sb.append("]");
                }
                sb.append("]");
            }
            if (this.query != null) {
                sb.append(", query=");
                sb.append(this.query.utf8ToString());
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndicesPrivileges that = (IndicesPrivileges)o;
            if (!Arrays.equals(this.indices, that.indices)) {
                return false;
            }
            if (this.allowRestrictedIndices != that.allowRestrictedIndices) {
                return false;
            }
            if (!Arrays.equals(this.privileges, that.privileges)) {
                return false;
            }
            if (!Arrays.equals(this.grantedFields, that.grantedFields)) {
                return false;
            }
            if (!Arrays.equals(this.deniedFields, that.deniedFields)) {
                return false;
            }
            return Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.indices);
            result = 31 * result + (this.allowRestrictedIndices ? 1 : 0);
            result = 31 * result + Arrays.hashCode(this.privileges);
            result = 31 * result + Arrays.hashCode(this.grantedFields);
            result = 31 * result + Arrays.hashCode(this.deniedFields);
            result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder, params.paramAsBoolean("_with_privileges", true));
            return builder.endObject();
        }

        XContentBuilder innerToXContent(XContentBuilder builder, boolean withPrivileges) throws IOException {
            builder.array("names", this.indices);
            if (withPrivileges) {
                builder.array("privileges", this.privileges);
            }
            if (this.grantedFields != null || this.deniedFields != null) {
                builder.startObject(Fields.FIELD_PERMISSIONS.getPreferredName());
                if (this.grantedFields != null) {
                    builder.array(Fields.GRANT_FIELDS.getPreferredName(), this.grantedFields);
                }
                if (this.deniedFields != null) {
                    builder.array(Fields.EXCEPT_FIELDS.getPreferredName(), this.deniedFields);
                }
                builder.endObject();
            }
            if (this.query != null) {
                builder.field("query", this.query.utf8ToString());
            }
            return builder.field(Fields.ALLOW_RESTRICTED_INDICES.getPreferredName(), this.allowRestrictedIndices);
        }

        public static void write(StreamOutput out, IndicesPrivileges privileges) throws IOException {
            privileges.writeTo(out);
        }

        @Override
        public int compareTo(IndicesPrivileges o) {
            if (this == o) {
                return 0;
            }
            int cmp = Boolean.compare(this.allowRestrictedIndices, o.allowRestrictedIndices);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Arrays.compare((Comparable[])this.indices, (Comparable[])o.indices);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Arrays.compare((Comparable[])this.privileges, (Comparable[])o.privileges);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Objects.compare(this.query, o.query, Comparator.nullsFirst(Comparable::compareTo));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Arrays.compare((Comparable[])this.grantedFields, (Comparable[])o.grantedFields);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Arrays.compare((Comparable[])this.deniedFields, (Comparable[])o.deniedFields);
            return cmp;
        }

        public static class Builder {
            private IndicesPrivileges indicesPrivileges = new IndicesPrivileges();

            private Builder() {
            }

            public Builder indices(String ... indices) {
                this.indicesPrivileges.indices = indices;
                return this;
            }

            public Builder indices(Collection<String> indices) {
                return this.indices(indices.toArray(new String[indices.size()]));
            }

            public Builder privileges(String ... privileges) {
                this.indicesPrivileges.privileges = privileges;
                return this;
            }

            public Builder privileges(Collection<String> privileges) {
                return this.privileges(privileges.toArray(new String[privileges.size()]));
            }

            public Builder grantedFields(String ... grantedFields) {
                this.indicesPrivileges.grantedFields = grantedFields;
                return this;
            }

            public Builder deniedFields(String ... deniedFields) {
                this.indicesPrivileges.deniedFields = deniedFields;
                return this;
            }

            public Builder query(@Nullable String query) {
                return this.query((BytesReference)(query == null ? null : new BytesArray(query)));
            }

            public Builder allowRestrictedIndices(boolean allow) {
                this.indicesPrivileges.allowRestrictedIndices = allow;
                return this;
            }

            public Builder query(@Nullable BytesReference query) {
                this.indicesPrivileges.query = query == null ? null : query;
                return this;
            }

            public IndicesPrivileges build() {
                if (this.indicesPrivileges.indices == null || this.indicesPrivileges.indices.length == 0) {
                    throw new IllegalArgumentException("indices privileges must refer to at least one index name or index name pattern");
                }
                if (this.indicesPrivileges.privileges == null || this.indicesPrivileges.privileges.length == 0) {
                    throw new IllegalArgumentException("indices privileges must define at least one privilege");
                }
                return this.indicesPrivileges;
            }
        }
    }

    public static final class RemoteIndicesPrivileges
    implements Writeable,
    ToXContentObject {
        public static final RemoteIndicesPrivileges[] NONE = new RemoteIndicesPrivileges[0];
        private final IndicesPrivileges indicesPrivileges;
        private final String[] remoteClusters;

        public RemoteIndicesPrivileges(IndicesPrivileges indicesPrivileges, String ... remoteClusters) {
            this.indicesPrivileges = indicesPrivileges;
            this.remoteClusters = remoteClusters;
        }

        public RemoteIndicesPrivileges(StreamInput in) throws IOException {
            this(new IndicesPrivileges(in), in.readStringArray());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.indicesPrivileges.innerToXContent(builder, true);
            builder.array(Fields.CLUSTERS.getPreferredName(), this.remoteClusters);
            return builder.endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.indicesPrivileges.writeTo(out);
            out.writeStringArray(this.remoteClusters);
        }

        public static Builder builder(String ... remoteClusters) {
            return new Builder(remoteClusters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteIndicesPrivileges that = (RemoteIndicesPrivileges)o;
            if (!this.indicesPrivileges.equals(that.indicesPrivileges)) {
                return false;
            }
            return Arrays.equals(this.remoteClusters, that.remoteClusters);
        }

        public int hashCode() {
            int result = this.indicesPrivileges.hashCode();
            result = 31 * result + Arrays.hashCode(this.remoteClusters);
            return result;
        }

        public String toString() {
            return "RemoteIndicesPrivileges{indicesPrivileges=" + String.valueOf(this.indicesPrivileges) + ", remoteClusters=" + Strings.arrayToCommaDelimitedString((Object[])this.remoteClusters) + "}";
        }

        public IndicesPrivileges indicesPrivileges() {
            return this.indicesPrivileges;
        }

        public String[] remoteClusters() {
            return this.remoteClusters;
        }

        public static class Builder {
            private final IndicesPrivileges.Builder indicesBuilder = new IndicesPrivileges.Builder();
            private final String[] remoteClusters;

            public Builder(String ... remoteClusters) {
                this.remoteClusters = remoteClusters;
            }

            public Builder indices(String ... indices) {
                this.indicesBuilder.indices(indices);
                return this;
            }

            public Builder privileges(String ... privileges) {
                this.indicesBuilder.privileges(privileges);
                return this;
            }

            public Builder privileges(Collection<String> privileges) {
                return this.privileges(privileges.toArray(new String[0]));
            }

            public Builder grantedFields(String ... grantedFields) {
                this.indicesBuilder.grantedFields(grantedFields);
                return this;
            }

            public Builder deniedFields(String ... deniedFields) {
                this.indicesBuilder.deniedFields(deniedFields);
                return this;
            }

            public Builder query(@Nullable String query) {
                return this.query((BytesReference)(query == null ? null : new BytesArray(query)));
            }

            public Builder query(@Nullable BytesReference query) {
                this.indicesBuilder.query(query);
                return this;
            }

            public Builder allowRestrictedIndices(boolean allow) {
                this.indicesBuilder.allowRestrictedIndices(allow);
                return this;
            }

            public RemoteIndicesPrivileges build() {
                if (this.remoteClusters == null || this.remoteClusters.length == 0) {
                    throw new IllegalArgumentException("the [" + String.valueOf(Fields.REMOTE_INDICES) + "] sub-field [" + String.valueOf(Fields.CLUSTERS) + "] must refer to at least one cluster alias or cluster alias pattern");
                }
                return new RemoteIndicesPrivileges(this.indicesBuilder.build(), this.remoteClusters);
            }
        }
    }

    public static class Restriction
    implements Writeable,
    ToXContentObject {
        public static final Restriction NONE = new Restriction((String[])null);
        private final String[] workflows;

        public Restriction(String[] workflows) {
            assert (workflows == null || workflows.length > 0) : "workflows cannot be an empty array";
            this.workflows = workflows;
        }

        public Restriction(StreamInput in) throws IOException {
            this(in.readOptionalStringArray());
        }

        public boolean hasWorkflows() {
            return this.workflows != null && this.workflows.length > 0;
        }

        public String[] getWorkflows() {
            return this.workflows;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.array(Fields.WORKFLOWS.getPreferredName(), this.workflows);
            return builder.endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalStringArray(this.workflows);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Restriction that = (Restriction)o;
            return Arrays.equals(this.workflows, that.workflows);
        }

        public int hashCode() {
            return Arrays.hashCode(this.workflows);
        }

        public boolean isEmpty() {
            return this.workflows == null || this.workflows.length == 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[workflows=[").append(Strings.arrayToCommaDelimitedString((Object[])this.workflows)).append("]]");
            return sb.toString();
        }

        public static Restriction parse(String roleName, XContentParser parser) throws IOException {
            XContentParser.Token token;
            XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse restriction for role [{}]. expected field [{}] value to be an object, but found an element of type [{}]", new Object[]{roleName, parser.currentName(), token});
            }
            String currentFieldName = null;
            String[] workflows = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Fields.WORKFLOWS.match(currentFieldName, parser.getDeprecationHandler())) {
                    workflows = Restriction.readWorkflowsStringArray(roleName, parser);
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse restriction for role [{}]. unexpected field [{}]", new Object[]{roleName, currentFieldName});
            }
            if (workflows != null && workflows.length <= 0) {
                throw new ElasticsearchParseException("failed to parse restriction for role [{}]. [{}] cannot be an empty array", new Object[]{roleName, Fields.WORKFLOWS});
            }
            return new Restriction(workflows);
        }

        private static String[] readWorkflowsStringArray(String roleName, XContentParser parser) throws IOException {
            try {
                return XContentUtils.readStringArray(parser, false);
            }
            catch (ElasticsearchParseException e) {
                throw new ElasticsearchParseException("failed to parse restriction for role [{}]. {}", (Throwable)e, new Object[]{roleName, e.getMessage()});
            }
        }
    }

    public static class ApplicationResourcePrivileges
    implements ToXContentObject,
    Writeable {
        private static final ApplicationResourcePrivileges[] NONE = new ApplicationResourcePrivileges[0];
        private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("application", ApplicationResourcePrivileges::builder);
        private String application;
        private String[] privileges;
        private String[] resources;

        private ApplicationResourcePrivileges() {
        }

        public ApplicationResourcePrivileges(StreamInput in) throws IOException {
            this.application = in.readString();
            this.privileges = in.readStringArray();
            this.resources = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.application);
            out.writeStringArray(this.privileges);
            out.writeStringArray(this.resources);
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getApplication() {
            return this.application;
        }

        public String[] getResources() {
            return this.resources;
        }

        public String[] getPrivileges() {
            return this.privileges;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[application=").append(this.application).append(", privileges=[").append(Strings.arrayToCommaDelimitedString((Object[])this.privileges)).append("], resources=[").append(Strings.arrayToCommaDelimitedString((Object[])this.resources)).append("]]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationResourcePrivileges that = (ApplicationResourcePrivileges)o;
            return Objects.equals(this.application, that.application) && Arrays.equals(this.resources, that.resources) && Arrays.equals(this.privileges, that.privileges);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.resources);
            result = 31 * result + Arrays.hashCode(this.privileges);
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.APPLICATION.getPreferredName(), this.application);
            builder.array(Fields.PRIVILEGES.getPreferredName(), this.privileges);
            builder.array(Fields.RESOURCES.getPreferredName(), this.resources);
            return builder.endObject();
        }

        public static void write(StreamOutput out, ApplicationResourcePrivileges privileges) throws IOException {
            privileges.writeTo(out);
        }

        static {
            PARSER.declareString(Builder::application, Fields.APPLICATION);
            PARSER.declareStringArray(Builder::privileges, Fields.PRIVILEGES);
            PARSER.declareStringArray(Builder::resources, Fields.RESOURCES);
        }

        public static class Builder {
            private ApplicationResourcePrivileges applicationPrivileges = new ApplicationResourcePrivileges();

            private Builder() {
            }

            public Builder application(String appName) {
                this.applicationPrivileges.application = appName;
                return this;
            }

            public Builder resources(String ... resources) {
                this.applicationPrivileges.resources = resources;
                return this;
            }

            public Builder resources(Collection<String> resources) {
                return this.resources(resources.toArray(new String[resources.size()]));
            }

            public Builder privileges(String ... privileges) {
                this.applicationPrivileges.privileges = privileges;
                return this;
            }

            public Builder privileges(Collection<String> privileges) {
                return this.privileges(privileges.toArray(new String[privileges.size()]));
            }

            public boolean hasResources() {
                return this.applicationPrivileges.resources != null;
            }

            public boolean hasPrivileges() {
                return this.applicationPrivileges.privileges != null;
            }

            public ApplicationResourcePrivileges build() {
                if (Strings.isNullOrEmpty((String)this.applicationPrivileges.application)) {
                    throw new IllegalArgumentException("application privileges must have an application name");
                }
                if (this.applicationPrivileges.privileges == null || this.applicationPrivileges.privileges.length == 0) {
                    throw new IllegalArgumentException("application privileges must define at least one privilege");
                }
                if (this.applicationPrivileges.resources == null || this.applicationPrivileges.resources.length == 0) {
                    throw new IllegalArgumentException("application privileges must refer to at least one resource");
                }
                return this.applicationPrivileges;
            }
        }
    }

    public static interface Fields {
        public static final ParseField CLUSTER = new ParseField("cluster", new String[0]);
        public static final ParseField GLOBAL = new ParseField("global", new String[0]);
        public static final ParseField INDEX = new ParseField("index", new String[0]);
        public static final ParseField INDICES = new ParseField("indices", new String[0]);
        public static final ParseField REMOTE_INDICES = new ParseField("remote_indices", new String[0]);
        public static final ParseField REMOTE_CLUSTER = new ParseField("remote_cluster", new String[0]);
        public static final ParseField APPLICATIONS = new ParseField("applications", new String[0]);
        public static final ParseField RUN_AS = new ParseField("run_as", new String[0]);
        public static final ParseField NAMES = new ParseField("names", new String[0]);
        public static final ParseField ALLOW_RESTRICTED_INDICES = new ParseField("allow_restricted_indices", new String[0]);
        public static final ParseField RESOURCES = new ParseField("resources", new String[0]);
        public static final ParseField QUERY = new ParseField("query", new String[0]);
        public static final ParseField PRIVILEGES = new ParseField("privileges", new String[0]);
        public static final ParseField CLUSTERS = new ParseField("clusters", new String[0]);
        public static final ParseField APPLICATION = new ParseField("application", new String[0]);
        public static final ParseField FIELD_PERMISSIONS = new ParseField("field_security", new String[0]);
        public static final ParseField FIELD_PERMISSIONS_2X = new ParseField("fields", new String[0]);
        public static final ParseField GRANT_FIELDS = new ParseField("grant", new String[0]);
        public static final ParseField EXCEPT_FIELDS = new ParseField("except", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField METADATA_FLATTENED = new ParseField("metadata_flattened", new String[0]);
        public static final ParseField TRANSIENT_METADATA = new ParseField("transient_metadata", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField RESTRICTION = new ParseField("restriction", new String[0]);
        public static final ParseField WORKFLOWS = new ParseField("workflows", new String[0]);
        public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    }

    public record Parser(boolean allow2xFormat, boolean allowRestriction, boolean allowDescription) {
        public RoleDescriptor parse(String name, BytesReference source, XContentType xContentType) throws IOException {
            assert (name != null);
            try (XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, (BytesReference)source, (XContentType)xContentType);){
                RoleDescriptor roleDescriptor = this.parse(name, parser);
                return roleDescriptor;
            }
        }

        public RoleDescriptor parse(String name, XContentParser parser) throws IOException {
            return this.parse(name, parser, true);
        }

        public RoleDescriptor parse(String name, XContentParser parser, boolean validate) throws IOException {
            XContentParser.Token token;
            Validation.Error validationError;
            if (validate && (validationError = Validation.Roles.validateRoleName(name, true)) != null) {
                ValidationException ve = new ValidationException();
                ve.addValidationError(validationError.toString());
                throw ve;
            }
            XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse role [{}]. expected an object but found [{}] instead", new Object[]{name, token});
            }
            String currentFieldName = null;
            IndicesPrivileges[] indicesPrivileges = null;
            RemoteIndicesPrivileges[] remoteIndicesPrivileges = null;
            RemoteClusterPermissions remoteClusterPermissions = null;
            String[] clusterPrivileges = null;
            List<ConfigurableClusterPrivilege> configurableClusterPrivileges = Collections.emptyList();
            ApplicationResourcePrivileges[] applicationPrivileges = null;
            String[] runAsUsers = null;
            Restriction restriction = null;
            Map metadata = null;
            String description = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (Fields.INDEX.match(currentFieldName, parser.getDeprecationHandler()) || Fields.INDICES.match(currentFieldName, parser.getDeprecationHandler())) {
                    indicesPrivileges = RoleDescriptor.parseIndices(name, parser, this.allow2xFormat);
                    continue;
                }
                if (Fields.RUN_AS.match(currentFieldName, parser.getDeprecationHandler())) {
                    runAsUsers = RoleDescriptor.readStringArray(name, parser, true);
                    continue;
                }
                if (Fields.CLUSTER.match(currentFieldName, parser.getDeprecationHandler())) {
                    clusterPrivileges = RoleDescriptor.readStringArray(name, parser, true);
                    continue;
                }
                if (Fields.APPLICATIONS.match(currentFieldName, parser.getDeprecationHandler()) || Fields.APPLICATION.match(currentFieldName, parser.getDeprecationHandler())) {
                    applicationPrivileges = RoleDescriptor.parseApplicationPrivileges(name, parser);
                    continue;
                }
                if (Fields.GLOBAL.match(currentFieldName, parser.getDeprecationHandler())) {
                    configurableClusterPrivileges = ConfigurableClusterPrivileges.parse(parser);
                    continue;
                }
                if (Fields.METADATA.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("expected field [{}] to be of type object, but found [{}] instead", new Object[]{currentFieldName, token});
                    }
                    metadata = parser.map();
                    continue;
                }
                if (Fields.METADATA_FLATTENED.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token != XContentParser.Token.START_OBJECT) {
                        throw new ElasticsearchParseException("expected field [{}] to be of type object, but found [{}] instead", new Object[]{currentFieldName, token});
                    }
                    parser.map();
                    continue;
                }
                if (Fields.TRANSIENT_METADATA.match(currentFieldName, parser.getDeprecationHandler())) {
                    if (token == XContentParser.Token.START_OBJECT) {
                        parser.map();
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse role [{}]. unexpected field [{}]", new Object[]{name, currentFieldName});
                }
                if (Fields.REMOTE_INDICES.match(currentFieldName, parser.getDeprecationHandler())) {
                    remoteIndicesPrivileges = RoleDescriptor.parseRemoteIndices(name, parser);
                    continue;
                }
                if (Fields.REMOTE_CLUSTER.match(currentFieldName, parser.getDeprecationHandler())) {
                    remoteClusterPermissions = RoleDescriptor.parseRemoteCluster(name, parser);
                    continue;
                }
                if (this.allowRestriction && Fields.RESTRICTION.match(currentFieldName, parser.getDeprecationHandler())) {
                    restriction = Restriction.parse(name, parser);
                    continue;
                }
                if (this.allowDescription && Fields.DESCRIPTION.match(currentFieldName, parser.getDeprecationHandler())) {
                    description = parser.text();
                    continue;
                }
                if (Fields.TYPE.match(currentFieldName, parser.getDeprecationHandler())) continue;
                throw new ElasticsearchParseException("failed to parse role [{}]. unexpected field [{}]", new Object[]{name, currentFieldName});
            }
            return new RoleDescriptor(name, clusterPrivileges, indicesPrivileges, applicationPrivileges, configurableClusterPrivileges.toArray(new ConfigurableClusterPrivilege[configurableClusterPrivileges.size()]), runAsUsers, metadata, null, remoteIndicesPrivileges, remoteClusterPermissions, restriction, description);
        }

        public static final class Builder {
            private boolean allow2xFormat = false;
            private boolean allowRestriction = false;
            private boolean allowDescription = false;

            private Builder() {
            }

            public Builder allow2xFormat(boolean allow2xFormat) {
                this.allow2xFormat = allow2xFormat;
                return this;
            }

            public Builder allowRestriction(boolean allowRestriction) {
                this.allowRestriction = allowRestriction;
                return this;
            }

            public Builder allowDescription(boolean allowDescription) {
                this.allowDescription = allowDescription;
                return this;
            }

            public Parser build() {
                return new Parser(this.allow2xFormat, this.allowRestriction, this.allowDescription);
            }
        }
    }

    private record IndicesPrivilegesWithOptionalRemoteClusters(IndicesPrivileges indicesPrivileges, String[] remoteClusters) {
    }
}

