/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.async.AsyncResponse;

public class AsyncSearchResponse
extends ActionResponse
implements ChunkedToXContentObject,
AsyncResponse<AsyncSearchResponse> {
    @Nullable
    private final String id;
    @Nullable
    private final SearchResponse searchResponse;
    @Nullable
    private final Exception error;
    private final boolean isRunning;
    private final boolean isPartial;
    private final long startTimeMillis;
    private final long expirationTimeMillis;
    private final RefCounted refCounted = LeakTracker.wrap((RefCounted)new AbstractRefCounted(){

        protected void closeInternal() {
            if (AsyncSearchResponse.this.searchResponse != null) {
                AsyncSearchResponse.this.searchResponse.decRef();
            }
        }
    });

    public AsyncSearchResponse(String id, boolean isPartial, boolean isRunning, long startTimeMillis, long expirationTimeMillis) {
        this(id, null, null, isPartial, isRunning, startTimeMillis, expirationTimeMillis);
    }

    public AsyncSearchResponse(String id, SearchResponse searchResponse, Exception error, boolean isPartial, boolean isRunning, long startTimeMillis, long expirationTimeMillis) {
        this.id = id;
        this.error = error;
        if (searchResponse != null) {
            searchResponse.mustIncRef();
        }
        this.searchResponse = searchResponse;
        this.isPartial = isPartial;
        this.isRunning = isRunning;
        this.startTimeMillis = startTimeMillis;
        this.expirationTimeMillis = expirationTimeMillis;
    }

    public AsyncSearchResponse(StreamInput in) throws IOException {
        this.id = in.readOptionalString();
        this.error = in.readBoolean() ? in.readException() : null;
        this.searchResponse = (SearchResponse)in.readOptionalWriteable(SearchResponse::new);
        this.isPartial = in.readBoolean();
        this.isRunning = in.readBoolean();
        this.startTimeMillis = in.readLong();
        this.expirationTimeMillis = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.id);
        if (this.error != null) {
            out.writeBoolean(true);
            out.writeException((Throwable)this.error);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalWriteable((Writeable)this.searchResponse);
        out.writeBoolean(this.isPartial);
        out.writeBoolean(this.isRunning);
        out.writeLong(this.startTimeMillis);
        out.writeLong(this.expirationTimeMillis);
    }

    public void incRef() {
        this.refCounted.incRef();
    }

    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    public boolean decRef() {
        return this.refCounted.decRef();
    }

    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }

    public AsyncSearchResponse clone(String searchId) {
        return new AsyncSearchResponse(searchId, this.searchResponse, this.error, this.isPartial, this.isRunning, this.startTimeMillis, this.expirationTimeMillis);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public SearchResponse getSearchResponse() {
        return this.searchResponse;
    }

    public Exception getFailure() {
        return this.error;
    }

    public boolean isPartial() {
        return this.isPartial;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getStartTime() {
        return this.startTimeMillis;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTimeMillis;
    }

    public Long getCompletionTime() {
        if (this.searchResponse == null || this.isRunning) {
            return null;
        }
        return this.getStartTime() + this.searchResponse.getTook().millis();
    }

    @Override
    public AsyncSearchResponse withExpirationTime(long expirationTime) {
        return new AsyncSearchResponse(this.id, this.searchResponse, this.error, this.isPartial, this.isRunning, this.startTimeMillis, expirationTime);
    }

    public RestStatus status() {
        if (this.searchResponse == null || this.isPartial) {
            return this.error != null ? ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)this.error)) : RestStatus.OK;
        }
        return this.searchResponse.status();
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.chunk((builder, p) -> {
            builder.startObject();
            if (this.id != null) {
                builder.field("id", this.id);
            }
            builder.field("is_partial", this.isPartial);
            builder.field("is_running", this.isRunning);
            builder.timestampFieldsFromUnixEpochMillis("start_time_in_millis", "start_time", this.startTimeMillis);
            builder.timestampFieldsFromUnixEpochMillis("expiration_time_in_millis", "expiration_time", this.expirationTimeMillis);
            if (this.searchResponse != null) {
                if (!this.isRunning) {
                    TimeValue took = this.searchResponse.getTook();
                    builder.timestampFieldsFromUnixEpochMillis("completion_time_in_millis", "completion_time", this.startTimeMillis + took.millis());
                }
                builder.field("response");
            }
            return builder;
        }), this.searchResponse == null ? Collections.emptyIterator() : this.searchResponse.toXContentChunked(params), ChunkedToXContentHelper.chunk((builder, p) -> {
            if (this.error != null) {
                builder.startObject("error");
                ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.error);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        })});
    }

    @Override
    public AsyncSearchResponse convertToFailure(Exception exc) {
        exc.setStackTrace(new StackTraceElement[0]);
        return new AsyncSearchResponse(this.id, null, exc, this.isPartial, false, this.startTimeMillis, this.expirationTimeMillis);
    }
}

