/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.QuestionAnsweringConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class QuestionAnsweringConfigUpdate
extends NlpConfigUpdate
implements NamedXContentObject {
    public static final String NAME = "question_answering";
    private static final ObjectParser<Builder, Void> STRICT_PARSER = new ObjectParser("question_answering", Builder::new);
    private final String question;
    private final Integer numTopClasses;
    private final Integer maxAnswerLength;
    private final String resultsField;

    public static QuestionAnsweringConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static QuestionAnsweringConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        Integer numTopClasses = (Integer)options.remove(NlpConfig.NUM_TOP_CLASSES.getPreferredName());
        Integer maxAnswerLength = (Integer)options.remove(QuestionAnsweringConfig.MAX_ANSWER_LENGTH.getPreferredName());
        String resultsField = (String)options.remove(NlpConfig.RESULTS_FIELD.getPreferredName());
        String question = (String)options.remove(QuestionAnsweringConfig.QUESTION.getPreferredName());
        TokenizationUpdate tokenizationUpdate = NlpConfigUpdate.tokenizationFromMap(options);
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", map.keySet());
        }
        return new QuestionAnsweringConfigUpdate(question, numTopClasses, maxAnswerLength, resultsField, tokenizationUpdate);
    }

    public QuestionAnsweringConfigUpdate(String question, @Nullable Integer numTopClasses, @Nullable Integer maxAnswerLength, @Nullable String resultsField, @Nullable TokenizationUpdate tokenizationUpdate) {
        super(tokenizationUpdate);
        this.question = ExceptionsHelper.requireNonNull(question, QuestionAnsweringConfig.QUESTION);
        this.numTopClasses = numTopClasses;
        this.maxAnswerLength = maxAnswerLength;
        this.resultsField = resultsField;
    }

    public QuestionAnsweringConfigUpdate(StreamInput in) throws IOException {
        super(in);
        this.question = in.readString();
        this.numTopClasses = in.readOptionalInt();
        this.maxAnswerLength = in.readOptionalInt();
        this.resultsField = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.question);
        out.writeOptionalInt(this.numTopClasses);
        out.writeOptionalInt(this.maxAnswerLength);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.numTopClasses != null) {
            builder.field(NlpConfig.NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        if (this.maxAnswerLength != null) {
            builder.field(QuestionAnsweringConfig.MAX_ANSWER_LENGTH.getPreferredName(), this.maxAnswerLength);
        }
        if (this.resultsField != null) {
            builder.field(NlpConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.field(QuestionAnsweringConfig.QUESTION.getPreferredName(), this.question);
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof QuestionAnsweringConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setQuestion(this.question).setNumTopClasses(this.numTopClasses).setMaxAnswerLength(this.maxAnswerLength).setResultsField(this.resultsField).setTokenizationUpdate(this.tokenizationUpdate);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuestionAnsweringConfigUpdate that = (QuestionAnsweringConfigUpdate)o;
        return Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.maxAnswerLength, that.maxAnswerLength) && Objects.equals(this.question, that.question) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.tokenizationUpdate, that.tokenizationUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.maxAnswerLength, this.numTopClasses, this.resultsField, this.tokenizationUpdate, this.question);
    }

    public Integer getNumTopClasses() {
        return this.numTopClasses;
    }

    public Integer getMaxAnswerLength() {
        return this.maxAnswerLength;
    }

    public String getQuestion() {
        return this.question;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_3_0;
    }

    static {
        STRICT_PARSER.declareString(Builder::setQuestion, QuestionAnsweringConfig.QUESTION);
        STRICT_PARSER.declareInt(Builder::setNumTopClasses, NlpConfig.NUM_TOP_CLASSES);
        STRICT_PARSER.declareInt(Builder::setMaxAnswerLength, QuestionAnsweringConfig.MAX_ANSWER_LENGTH);
        STRICT_PARSER.declareString(Builder::setResultsField, NlpConfig.RESULTS_FIELD);
        STRICT_PARSER.declareNamedObject(Builder::setTokenizationUpdate, (p, c, n) -> (TokenizationUpdate)p.namedObject(TokenizationUpdate.class, n, (Object)false), NlpConfig.TOKENIZATION);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, QuestionAnsweringConfigUpdate> {
        private Integer numTopClasses;
        private Integer maxAnswerLength;
        private String resultsField;
        private TokenizationUpdate tokenizationUpdate;
        private String question;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setMaxAnswerLength(Integer maxAnswerLength) {
            this.maxAnswerLength = maxAnswerLength;
            return this;
        }

        public Builder setTokenizationUpdate(TokenizationUpdate tokenizationUpdate) {
            this.tokenizationUpdate = tokenizationUpdate;
            return this;
        }

        public Builder setQuestion(String question) {
            this.question = question;
            return this;
        }

        @Override
        public QuestionAnsweringConfigUpdate build() {
            return new QuestionAnsweringConfigUpdate(this.question, this.numTopClasses, this.maxAnswerLength, this.resultsField, this.tokenizationUpdate);
        }
    }
}

