/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.ShrinkIndexNameSupplier;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.SwapAliasesAndDeleteSourceIndexStep;

public class ShrinkSetAliasStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "aliases";

    public ShrinkSetAliasStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performDuringNoSnapshot(IndexMetadata indexMetadata, ProjectMetadata currentProject, ActionListener<Void> listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String targetIndexName = ShrinkIndexNameSupplier.getShrinkIndexName(indexName, lifecycleState);
        SwapAliasesAndDeleteSourceIndexStep.deleteSourceIndexAndTransferAliases(this.getClient(currentProject.id()), indexMetadata, targetIndexName, listener, true);
    }

    @Override
    public boolean indexSurvives() {
        return false;
    }
}

