/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.profiling.action.FrameGroupID;
import org.elasticsearch.xpack.profiling.action.GetFlamegraphResponse;
import org.elasticsearch.xpack.profiling.action.GetStackTracesAction;
import org.elasticsearch.xpack.profiling.action.GetStackTracesRequest;
import org.elasticsearch.xpack.profiling.action.GetStackTracesResponse;
import org.elasticsearch.xpack.profiling.action.StackFrame;
import org.elasticsearch.xpack.profiling.action.StackTrace;
import org.elasticsearch.xpack.profiling.action.StopWatch;

public class TransportGetFlamegraphAction
extends TransportAction<GetStackTracesRequest, GetFlamegraphResponse> {
    public static final int FRAMETYPE_ROOT = 256;
    public static final int FRAMETYPE_EXECUTABLE = 259;
    public static final int FRAMETYPE_THREAD = 258;
    private static final Logger log = LogManager.getLogger(TransportGetFlamegraphAction.class);
    private final NodeClient nodeClient;
    private final TransportService transportService;

    @Inject
    public TransportGetFlamegraphAction(NodeClient nodeClient, TransportService transportService, ActionFilters actionFilters) {
        super("indices:data/read/profiling/flamegraph", actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeClient = nodeClient;
        this.transportService = transportService;
    }

    protected void doExecute(Task task, GetStackTracesRequest request, final ActionListener<GetFlamegraphResponse> listener) {
        ParentTaskAssigningClient client = new ParentTaskAssigningClient((Client)this.nodeClient, this.transportService.getLocalNode(), task);
        final StopWatch watch = new StopWatch("getFlamegraphAction");
        client.execute((ActionType)GetStackTracesAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<GetStackTracesResponse>(this){

            public void onResponse(GetStackTracesResponse response) {
                try {
                    StopWatch processingWatch = new StopWatch("Processing response");
                    GetFlamegraphResponse flamegraphResponse = TransportGetFlamegraphAction.buildFlamegraph(response);
                    log.debug(() -> watch.report() + " " + processingWatch.report());
                    listener.onResponse((Object)flamegraphResponse);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static GetFlamegraphResponse buildFlamegraph(GetStackTracesResponse response) {
        FlamegraphBuilder builder = new FlamegraphBuilder(response.getTotalSamples(), response.getTotalFrames(), response.getSamplingRate());
        if (response.getTotalFrames() == 0) {
            return builder.build();
        }
        Map<String, StackTrace> stackTraces = response.getStackTraces();
        AtomicInteger lostStackTraces = new AtomicInteger();
        response.getStackTraceEvents().forEach((eventId, event) -> {
            StackTrace stackTrace = (StackTrace)stackTraces.get(eventId.stacktraceID());
            if (stackTrace == null) {
                lostStackTraces.getAndIncrement();
                return;
            }
            long samples = event.count;
            double annualCO2Tons = event.annualCO2Tons;
            double annualCostsUSD = event.annualCostsUSD;
            String executableName = eventId.executableName();
            if (executableName.isEmpty() && stackTrace.typeIds.length > 0 && stackTrace.typeIds[0] == 4) {
                executableName = "kernel";
            }
            builder.setCurrentNode(0);
            builder.addToRootNode(samples, annualCO2Tons, annualCostsUSD);
            builder.addOrUpdateAggregationNode(executableName, samples, annualCO2Tons, annualCostsUSD, 259);
            builder.addOrUpdateAggregationNode(eventId.threadName(), samples, annualCO2Tons, annualCostsUSD, 258);
            int frameCount = stackTrace.frameIds.length;
            for (int i = 0; i < frameCount; ++i) {
                String frameId = stackTrace.frameIds[i];
                String fileId = stackTrace.fileIds[i];
                int frameType = stackTrace.typeIds[i];
                int addressOrLine = stackTrace.addressOrLines[i];
                StackFrame stackFrame = response.getStackFrames().getOrDefault(frameId, StackFrame.EMPTY_STACKFRAME);
                String executable = response.getExecutables().getOrDefault(fileId, "");
                boolean isLeafFrame = i == frameCount - 1;
                stackFrame.forEach(frame -> {
                    String frameGroupId = FrameGroupID.create(fileId, addressOrLine, executable, frame.fileName(), frame.functionName());
                    int nodeId = builder.getNodeId(frameGroupId);
                    if (nodeId != -1) {
                        builder.addSamplesInclusive(nodeId, samples);
                        builder.addAnnualCO2TonsInclusive(nodeId, annualCO2Tons);
                        builder.addAnnualCostsUSDInclusive(nodeId, annualCostsUSD);
                    } else {
                        nodeId = builder.addNode(fileId, frameType, frame.inline(), executable, addressOrLine, frame.functionName(), frame.functionOffset(), frame.fileName(), frame.lineNumber(), samples, annualCO2Tons, annualCostsUSD, frameGroupId);
                    }
                    if (isLeafFrame && frame.last()) {
                        builder.addSamplesExclusive(nodeId, samples);
                        builder.addAnnualCO2TonsExclusive(nodeId, annualCO2Tons);
                        builder.addAnnualCostsUSDExclusive(nodeId, annualCostsUSD);
                    }
                    builder.setCurrentNode(nodeId);
                });
            }
        });
        return builder.build();
    }

    private static class FlamegraphBuilder {
        private int currentNode = 0;
        private int size = 0;
        private long selfCPU;
        private long totalCPU;
        private final long totalSamples;
        private final List<Map<String, Integer>> edges;
        private final List<String> fileIds;
        private final List<Integer> frameTypes;
        private final List<Boolean> inlineFrames;
        private final List<String> fileNames;
        private final List<Integer> addressOrLines;
        private final List<String> functionNames;
        private final List<Integer> functionOffsets;
        private final List<String> sourceFileNames;
        private final List<Integer> sourceLines;
        private final List<Long> countInclusive;
        private final List<Long> countExclusive;
        private final List<Double> annualCO2TonsExclusive;
        private final List<Double> annualCO2TonsInclusive;
        private final List<Double> annualCostsUSDExclusive;
        private final List<Double> annualCostsUSDInclusive;
        private final double samplingRate;

        FlamegraphBuilder(long totalSamples, int frames, double samplingRate) {
            int capacity = (int)((double)frames * 1.1);
            this.edges = new ArrayList<Map<String, Integer>>(capacity);
            this.fileIds = new ArrayList<String>(capacity);
            this.frameTypes = new ArrayList<Integer>(capacity);
            this.inlineFrames = new ArrayList<Boolean>(capacity);
            this.fileNames = new ArrayList<String>(capacity);
            this.addressOrLines = new ArrayList<Integer>(capacity);
            this.functionNames = new ArrayList<String>(capacity);
            this.functionOffsets = new ArrayList<Integer>(capacity);
            this.sourceFileNames = new ArrayList<String>(capacity);
            this.sourceLines = new ArrayList<Integer>(capacity);
            this.countInclusive = new ArrayList<Long>(capacity);
            this.countExclusive = new ArrayList<Long>(capacity);
            this.annualCO2TonsInclusive = new ArrayList<Double>(capacity);
            this.annualCO2TonsExclusive = new ArrayList<Double>(capacity);
            this.annualCostsUSDInclusive = new ArrayList<Double>(capacity);
            this.annualCostsUSDExclusive = new ArrayList<Double>(capacity);
            this.totalSamples = totalSamples;
            this.samplingRate = samplingRate;
            int nodeId = this.addNode("", 256, false, "", 0, "", 0, "", 0, 0L, 0.0, 0.0, null);
            this.setCurrentNode(nodeId);
        }

        public int addNode(String fileId, int frameType, boolean inline, String fileName, int addressOrLine, String functionName, int functionOffset, String sourceFileName, int sourceLine, long samples, double annualCO2Tons, double annualCostsUSD, String frameGroupId) {
            int node = this.size;
            this.edges.add(new HashMap());
            this.fileIds.add(fileId);
            this.frameTypes.add(frameType);
            this.inlineFrames.add(inline);
            this.fileNames.add(fileName);
            this.addressOrLines.add(addressOrLine);
            this.functionNames.add(functionName);
            this.functionOffsets.add(functionOffset);
            this.sourceFileNames.add(sourceFileName);
            this.sourceLines.add(sourceLine);
            this.countInclusive.add(samples);
            this.totalCPU += samples;
            this.countExclusive.add(0L);
            this.annualCO2TonsInclusive.add(annualCO2Tons);
            this.annualCO2TonsExclusive.add(0.0);
            this.annualCostsUSDInclusive.add(annualCostsUSD);
            this.annualCostsUSDExclusive.add(0.0);
            if (frameGroupId != null) {
                this.edges.get(this.currentNode).put(frameGroupId, node);
            }
            ++this.size;
            return node;
        }

        public void addToRootNode(long samples, double annualCO2Tons, double annualCostsUSD) {
            this.addSamplesInclusive(0, samples);
            this.addAnnualCO2TonsInclusive(0, annualCO2Tons);
            this.addAnnualCostsUSDInclusive(0, annualCostsUSD);
        }

        public void addOrUpdateAggregationNode(String name, long samples, double annualCO2Tons, double annualCostsUSD, int frameType) {
            String frameGroupId = Integer.toString(Objects.hash(name, frameType));
            int nodeId = this.getNodeId(frameGroupId);
            if (nodeId != -1) {
                this.addSamplesInclusive(nodeId, samples);
                this.addAnnualCO2TonsInclusive(nodeId, annualCO2Tons);
                this.addAnnualCostsUSDInclusive(nodeId, annualCostsUSD);
                this.setCurrentNode(nodeId);
            } else {
                this.setCurrentNode(this.addNode("", frameType, false, name, 0, "", 0, "", 0, samples, annualCO2Tons, annualCostsUSD, frameGroupId));
            }
        }

        public void setCurrentNode(int nodeId) {
            this.currentNode = nodeId;
        }

        public boolean isExists(String frameGroupId) {
            return this.edges.get(this.currentNode).containsKey(frameGroupId);
        }

        public int getNodeId(String frameGroupId) {
            return this.edges.get(this.currentNode).getOrDefault(frameGroupId, -1);
        }

        public void addSamplesInclusive(int nodeId, long sampleCount) {
            Long priorSampleCount = this.countInclusive.get(nodeId);
            this.countInclusive.set(nodeId, priorSampleCount + sampleCount);
            this.totalCPU += sampleCount;
        }

        public void addSamplesExclusive(int nodeId, long sampleCount) {
            Long priorSampleCount = this.countExclusive.get(nodeId);
            this.countExclusive.set(nodeId, priorSampleCount + sampleCount);
            this.selfCPU += sampleCount;
        }

        public void addAnnualCO2TonsInclusive(int nodeId, double annualCO2Tons) {
            Double priorAnnualCO2Tons = this.annualCO2TonsInclusive.get(nodeId);
            this.annualCO2TonsInclusive.set(nodeId, priorAnnualCO2Tons + annualCO2Tons);
        }

        public void addAnnualCO2TonsExclusive(int nodeId, double annualCO2Tons) {
            Double priorAnnualCO2Tons = this.annualCO2TonsExclusive.get(nodeId);
            this.annualCO2TonsExclusive.set(nodeId, priorAnnualCO2Tons + annualCO2Tons);
        }

        public void addAnnualCostsUSDInclusive(int nodeId, double annualCostsUSD) {
            Double priorAnnualCostsUSD = this.annualCostsUSDInclusive.get(nodeId);
            this.annualCostsUSDInclusive.set(nodeId, priorAnnualCostsUSD + annualCostsUSD);
        }

        public void addAnnualCostsUSDExclusive(int nodeId, double annualCostsUSD) {
            Double priorAnnualCostsUSD = this.annualCostsUSDExclusive.get(nodeId);
            this.annualCostsUSDExclusive.set(nodeId, priorAnnualCostsUSD + annualCostsUSD);
        }

        public GetFlamegraphResponse build() {
            return new GetFlamegraphResponse(this.size, this.samplingRate, this.edges, this.fileIds, this.frameTypes, this.inlineFrames, this.fileNames, this.addressOrLines, this.functionNames, this.functionOffsets, this.sourceFileNames, this.sourceLines, this.countInclusive, this.countExclusive, this.annualCO2TonsInclusive, this.annualCO2TonsExclusive, this.annualCostsUSDInclusive, this.annualCostsUSDExclusive, this.selfCPU, this.totalCPU, this.totalSamples);
        }
    }
}

