/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Set;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.PipelineBreaker;
import org.elasticsearch.xpack.esql.plan.logical.Streaming;

public final class HoistRemoteEnrichLimit
extends OptimizerRules.ParameterizedOptimizerRule<Enrich, LogicalOptimizerContext>
implements OptimizerRules.CoordinatorOnly {
    public HoistRemoteEnrichLimit() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    protected LogicalPlan rule(Enrich en, LogicalOptimizerContext ctx) {
        if (en.mode() == Enrich.Mode.REMOTE) {
            Set seenLimits = Collections.newSetFromMap(new IdentityHashMap());
            en.child().forEachDownMayReturnEarly((p, stop) -> {
                Enrich e;
                ExecutesOn ex;
                Limit l;
                if (p instanceof Limit && !(l = (Limit)p).local()) {
                    seenLimits.add(l);
                    return;
                }
                if (!(p instanceof Streaming) || p instanceof ExecutesOn && (ex = (ExecutesOn)((Object)p)).executesOn() == ExecutesOn.ExecuteLocation.COORDINATOR || p instanceof Enrich && (e = (Enrich)p).mode() == Enrich.Mode.REMOTE || p instanceof PipelineBreaker) {
                    stop.set((Object)true);
                }
            });
            if (seenLimits.isEmpty()) {
                return en;
            }
            LogicalPlan transformLimits = (LogicalPlan)en.transformDown(Limit.class, l -> seenLimits.contains(l) ? l.withLocal(true) : l);
            Limit lowestLimit = seenLimits.stream().min(Comparator.comparing(l -> (int)((Integer)l.limit().fold(ctx.foldCtx())))).orElseThrow();
            return new Limit(lowestLimit.source(), lowestLimit.limit(), transformLimits, true, false);
        }
        return en;
    }
}

