/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.h3.CellBoundary;
import org.elasticsearch.h3.H3;
import org.elasticsearch.h3.LatLng;
import org.elasticsearch.license.License;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.GeoHexBoundedPredicate;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialGridFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohexFromFieldAndLiteralAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohexFromFieldAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohexFromFieldDocValuesAndLiteralAndLiteralEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohexFromFieldDocValuesAndLiteralEvaluator;

public class StGeohex
extends SpatialGridFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StGeohex", StGeohex::new);
    public static final SpatialGridFunction.UnboundedGrid unboundedGrid = (point, precision) -> H3.geoToH3((double)point.getLat(), (double)point.getLon(), (int)StGeohex.checkPrecisionRange(precision));

    private static int checkPrecisionRange(int precision) {
        if (precision < 0 || precision > 15) {
            throw new IllegalArgumentException("Invalid geohex_grid precision of " + precision + ". Must be between 0 and 15.");
        }
        return precision;
    }

    @FunctionInfo(returnType={"geohex"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Calculates the `geohex`, the H3 cell-id, of the supplied geo_point at the specified precision.\nThe result is long encoded. Use [TO_STRING](#esql-to_string) to convert the result to a string,\n[TO_LONG](#esql-to_long) to convert it to a `long`, or [TO_GEOSHAPE](#esql-to_geoshape) to calculate\nthe `geo_shape` bounding geometry.\n\nThese functions are related to the [`geo_grid` query](/reference/query-languages/query-dsl/query-dsl-geo-grid-query.md)\nand the [`geohex_grid` aggregation](/reference/aggregations/search-aggregations-bucket-geohexgrid-aggregation.md).", examples={@Example(file="spatial-grid", tag="st_geohex-grid")})
    public StGeohex(Source source, @Param(name="geometry", type={"geo_point"}, description="Expression of type `geo_point`. If `null`, the function returns `null`.") Expression field, @Param(name="precision", type={"integer"}, description="Expression of type `integer`. If `null`, the function returns `null`.\nValid values are between [0 and 15](https://h3geo.org/docs/core-library/restable/).") Expression precision, @Param(name="bounds", type={"geo_shape"}, description="Optional bounds to filter the grid tiles, a `geo_shape` of type `BBOX`.\nUse [`ST_ENVELOPE`](#esql-st_envelope) if the `geo_shape` is of any other type.", optional=true) Expression bounds) {
        this(source, field, precision, bounds, false);
    }

    private StGeohex(Source source, Expression field, Expression precision, Expression bounds, boolean spatialDocValues) {
        super(source, field, precision, bounds, spatialDocValues);
    }

    private StGeohex(StreamInput in) throws IOException {
        super(in, false);
    }

    @Override
    public boolean licenseCheck(XPackLicenseState state) {
        return state.isAllowedByLicense(License.OperationMode.PLATINUM);
    }

    @Override
    public SpatialGridFunction withDocValues(boolean useDocValues) {
        boolean docValues = this.spatialDocsValues || useDocValues;
        return new StGeohex(this.source(), this.spatialField, this.parameter, this.bounds, docValues);
    }

    public String getWriteableName() {
        return StGeohex.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.GEOHEX;
    }

    @Override
    protected SpatialGridFunction replaceChildren(Expression newSpatialField, Expression newParameter, Expression newBounds) {
        return new StGeohex(this.source(), newSpatialField, newParameter, newBounds);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StGeohex::new, (Object)this.spatialField, (Object)this.parameter, (Object)this.bounds);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (!this.parameter().foldable()) {
            throw new IllegalArgumentException("precision must be foldable");
        }
        if (this.bounds != null) {
            if (!this.bounds.foldable()) {
                throw new IllegalArgumentException("bounds must be foldable");
            }
            GeoBoundingBox bbox = StGeohex.asGeoBoundingBox(this.bounds.fold(toEvaluator.foldCtx()));
            int precision = (Integer)this.parameter.fold(toEvaluator.foldCtx());
            GeoHexBoundedGrid.Factory bounds = new GeoHexBoundedGrid.Factory(precision, bbox);
            return this.spatialDocsValues ? new StGeohexFromFieldDocValuesAndLiteralAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()), bounds::get) : new StGeohexFromFieldAndLiteralAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField), bounds::get);
        }
        int precision = StGeohex.checkPrecisionRange((Integer)this.parameter.fold(toEvaluator.foldCtx()));
        return this.spatialDocsValues ? new StGeohexFromFieldDocValuesAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField()), precision) : new StGeohexFromFieldAndLiteralEvaluator.Factory(this.source(), toEvaluator.apply(this.spatialField), precision);
    }

    public Object fold(FoldContext ctx) {
        BytesRef point = (BytesRef)this.spatialField().fold(ctx);
        int precision = StGeohex.checkPrecisionRange((Integer)this.parameter().fold(ctx));
        if (this.bounds() == null) {
            return unboundedGrid.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(point), precision);
        }
        GeoBoundingBox bbox = StGeohex.asGeoBoundingBox(this.bounds().fold(ctx));
        GeoHexBoundedGrid bounds = new GeoHexBoundedGrid(precision, bbox);
        long gridId = bounds.calculateGridId(SpatialCoordinateTypes.GEO.wkbAsPoint(point));
        return gridId < 0L ? null : Long.valueOf(gridId);
    }

    static void fromFieldAndLiteral(LongBlock.Builder results, int p, BytesRefBlock wkbBlock, int precision) {
        StGeohex.fromWKB(results, p, wkbBlock, precision, unboundedGrid);
    }

    static void fromFieldDocValuesAndLiteral(LongBlock.Builder results, int p, LongBlock encoded, int precision) {
        StGeohex.fromEncodedLong(results, p, encoded, precision, unboundedGrid);
    }

    static void fromFieldAndLiteralAndLiteral(LongBlock.Builder results, int p, BytesRefBlock in, GeoHexBoundedGrid bounds) {
        StGeohex.fromWKB(results, p, in, bounds);
    }

    static void fromFieldDocValuesAndLiteralAndLiteral(LongBlock.Builder results, int p, LongBlock encoded, GeoHexBoundedGrid bounds) {
        StGeohex.fromEncodedLong(results, p, encoded, bounds);
    }

    public static BytesRef toBounds(long gridId) {
        return StGeohex.fromCellBoundary(H3.h3ToGeoBoundary((long)gridId));
    }

    private static BytesRef fromCellBoundary(CellBoundary cell) {
        double[] x = new double[cell.numPoints() + 1];
        double[] y = new double[cell.numPoints() + 1];
        for (int i = 0; i < cell.numPoints(); ++i) {
            LatLng vertex = cell.getLatLon(i);
            x[i] = vertex.getLonDeg();
            y[i] = vertex.getLatDeg();
        }
        x[cell.numPoints()] = x[0];
        y[cell.numPoints()] = y[0];
        LinearRing ring = new LinearRing(x, y);
        Polygon polygon = new Polygon(ring);
        return SpatialCoordinateTypes.GEO.asWkb((Geometry)polygon);
    }

    protected static class GeoHexBoundedGrid
    implements SpatialGridFunction.BoundedGrid {
        private final int precision;
        private final GeoHexBoundedPredicate bounds;

        private GeoHexBoundedGrid(int precision, GeoBoundingBox bbox) {
            this.precision = StGeohex.checkPrecisionRange(precision);
            this.bounds = new GeoHexBoundedPredicate(bbox);
        }

        @Override
        public long calculateGridId(Point point) {
            long geohex = H3.geoToH3((double)point.getLat(), (double)point.getLon(), (int)this.precision);
            if (this.bounds.validHex(geohex)) {
                return geohex;
            }
            return -1L;
        }

        @Override
        public int precision() {
            return this.precision;
        }

        protected static class Factory {
            private final int precision;
            private final GeoBoundingBox bbox;

            Factory(int precision, GeoBoundingBox bbox) {
                this.precision = StGeohex.checkPrecisionRange(precision);
                this.bbox = bbox;
            }

            public GeoHexBoundedGrid get(DriverContext context) {
                return new GeoHexBoundedGrid(this.precision, this.bbox);
            }
        }
    }
}

