/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class MvContains
extends BinaryScalarFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MvContains", MvContains::new);

    @FunctionInfo(returnType={"boolean"}, description="Checks if all values yielded by the second multivalue expression are present in the values yielded by the first multivalue expression. Returns a boolean. Null values are treated as an empty set.", examples={@Example(file="string", tag="mv_contains"), @Example(file="string", tag="mv_contains_bothsides"), @Example(file="string", tag="mv_contains_where")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")})
    public MvContains(Source source, @Param(name="superset", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression superset, @Param(name="subset", type={"boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "geohash", "geotile", "geohex", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Multivalue expression.") Expression subset) {
        super(source, superset, subset);
    }

    private MvContains(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return MvContains.ENTRY.name;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isRepresentableExceptCountersDenseVectorAndAggregateMetricDouble((Expression)this.left(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.left().dataType() == DataType.NULL) {
            return TypeResolutions.isRepresentableExceptCountersDenseVectorAndAggregateMetricDouble((Expression)this.right(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        }
        return TypeResolutions.isType((Expression)this.right(), t -> t.noText() == this.left().dataType().noText(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{this.left().dataType().noText().typeName()});
    }

    public DataType dataType() {
        return DataType.BOOLEAN;
    }

    public Nullability nullable() {
        return Nullability.FALSE;
    }

    protected MvContains replaceChildren(Expression newLeft, Expression newRight) {
        return new MvContains(this.source(), newLeft, newRight);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvContains::new, (Object)this.left(), (Object)this.right());
    }

    public Object fold(FoldContext ctx) {
        return EvaluatorMapper.super.fold(this.source(), ctx);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        ElementType supersetType = PlannerUtils.toElementType(this.left().dataType());
        ElementType subsetType = PlannerUtils.toElementType(this.right().dataType());
        if (subsetType == ElementType.NULL) {
            return EvalOperator.CONSTANT_TRUE_FACTORY;
        }
        if (supersetType != ElementType.NULL && supersetType != subsetType) {
            throw new EsqlIllegalArgumentException("Incompatible data types for MvContains, superset type({}) value({}) and subset type({}) value({}) don't match.", supersetType, this.left(), subsetType, this.right());
        }
        return switch (supersetType) {
            case ElementType.BOOLEAN -> new MvContainsBooleanEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.BYTES_REF -> new MvContainsBytesRefEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.DOUBLE -> new MvContainsDoubleEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.INT -> new MvContainsIntEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.LONG -> new MvContainsLongEvaluator.Factory(this.source(), toEvaluator.apply(this.left()), toEvaluator.apply(this.right()));
            case ElementType.NULL -> new IsNull.IsNullEvaluatorFactory(toEvaluator.apply(this.right()));
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.dataType());
        };
    }

    static void process(BooleanBlock.Builder builder, int position, IntBlock field1, IntBlock field2) {
        MvContains.appendTo(builder, MvContains.containsAll(field1, field2, position, IntBlock::getInt));
    }

    static void process(BooleanBlock.Builder builder, int position, BooleanBlock field1, BooleanBlock field2) {
        MvContains.appendTo(builder, MvContains.containsAll(field1, field2, position, BooleanBlock::getBoolean));
    }

    static void process(BooleanBlock.Builder builder, int position, LongBlock field1, LongBlock field2) {
        MvContains.appendTo(builder, MvContains.containsAll(field1, field2, position, LongBlock::getLong));
    }

    static void process(BooleanBlock.Builder builder, int position, DoubleBlock field1, DoubleBlock field2) {
        MvContains.appendTo(builder, MvContains.containsAll(field1, field2, position, DoubleBlock::getDouble));
    }

    static void process(BooleanBlock.Builder builder, int position, BytesRefBlock field1, BytesRefBlock field2) {
        MvContains.appendTo(builder, MvContains.containsAll(field1, field2, position, (block, index) -> {
            BytesRef ref = new BytesRef();
            ref = block.getBytesRef(index, ref);
            if (ref.length == 0) {
                return null;
            }
            return ref;
        }));
    }

    static void appendTo(BooleanBlock.Builder builder, Boolean bool) {
        if (bool == null) {
            builder.appendNull();
        } else {
            builder.beginPositionEntry().appendBoolean(bool.booleanValue()).endPositionEntry();
        }
    }

    static <BlockType extends Block, Type> Boolean containsAll(BlockType superset, BlockType subset, int position, ValueExtractor<BlockType, Type> valueExtractor) {
        int startIndex;
        if (superset == subset) {
            return true;
        }
        if (subset.areAllValuesNull()) {
            return true;
        }
        int valueCount = subset.getValueCount(position);
        for (int valueIndex = startIndex = subset.getFirstValueIndex(position); valueIndex < startIndex + valueCount; ++valueIndex) {
            Type value = valueExtractor.extractValue(subset, valueIndex);
            if (value == null || MvContains.hasValue(superset, position, value, valueExtractor)) continue;
            return false;
        }
        return true;
    }

    static <BlockType extends Block, Type> boolean hasValue(BlockType superset, int position, Type value, ValueExtractor<BlockType, Type> valueExtractor) {
        int startIndex;
        int supersetCount = superset.getValueCount(position);
        for (int supersetIndex = startIndex = superset.getFirstValueIndex(position); supersetIndex < startIndex + supersetCount; ++supersetIndex) {
            Type element = valueExtractor.extractValue(superset, supersetIndex);
            if (element == null || !element.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static class MvContainsBooleanEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvContainsBooleanEvaluator.class);
        private final EvalOperator.ExpressionEvaluator field1;
        private final EvalOperator.ExpressionEvaluator field2;
        private final DriverContext driverContext;

        public MvContainsBooleanEvaluator(EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
            this.field1 = field1;
            this.field2 = field2;
            this.driverContext = driverContext;
        }

        public Block eval(Page page) {
            try (BooleanBlock field1Block = (BooleanBlock)this.field1.eval(page);){
                BooleanBlock booleanBlock;
                block12: {
                    BooleanBlock field2Block = (BooleanBlock)this.field2.eval(page);
                    try {
                        booleanBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                        if (field2Block == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (field2Block != null) {
                            try {
                                field2Block.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    field2Block.close();
                }
                return booleanBlock;
            }
        }

        public BooleanBlock eval(int positionCount, BooleanBlock field1Block, BooleanBlock field2Block) {
            try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    MvContains.process(result, p, field1Block, field2Block);
                }
                BooleanBlock booleanBlock = result.build();
                return booleanBlock;
            }
        }

        public String toString() {
            return "MvContainsBooleanEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
        }

        public long baseRamBytesUsed() {
            long baseRamBytesUsed = BASE_RAM_BYTES_USED;
            baseRamBytesUsed += this.field1.baseRamBytesUsed();
            return baseRamBytesUsed += this.field2.baseRamBytesUsed();
        }

        public static class Factory
        implements EvalOperator.ExpressionEvaluator.Factory {
            private final Source source;
            private final EvalOperator.ExpressionEvaluator.Factory field1;
            private final EvalOperator.ExpressionEvaluator.Factory field2;

            public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
                this.source = source;
                this.field1 = field1;
                this.field2 = field2;
            }

            public MvContainsBooleanEvaluator get(DriverContext context) {
                return new MvContainsBooleanEvaluator(this.field1.get(context), this.field2.get(context), context);
            }

            public String toString() {
                return "MvContainsBooleanEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
            }
        }
    }

    public static class MvContainsBytesRefEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvContainsBytesRefEvaluator.class);
        private final EvalOperator.ExpressionEvaluator field1;
        private final EvalOperator.ExpressionEvaluator field2;
        private final DriverContext driverContext;

        public MvContainsBytesRefEvaluator(EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
            this.field1 = field1;
            this.field2 = field2;
            this.driverContext = driverContext;
        }

        public Block eval(Page page) {
            try (BytesRefBlock field1Block = (BytesRefBlock)this.field1.eval(page);){
                BooleanBlock booleanBlock;
                block12: {
                    BytesRefBlock field2Block = (BytesRefBlock)this.field2.eval(page);
                    try {
                        booleanBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                        if (field2Block == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (field2Block != null) {
                            try {
                                field2Block.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    field2Block.close();
                }
                return booleanBlock;
            }
        }

        public BooleanBlock eval(int positionCount, BytesRefBlock field1Block, BytesRefBlock field2Block) {
            try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    MvContains.process(result, p, field1Block, field2Block);
                }
                BooleanBlock booleanBlock = result.build();
                return booleanBlock;
            }
        }

        public String toString() {
            return "MvContainsBytesRefEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
        }

        public long baseRamBytesUsed() {
            long baseRamBytesUsed = BASE_RAM_BYTES_USED;
            baseRamBytesUsed += this.field1.baseRamBytesUsed();
            return baseRamBytesUsed += this.field2.baseRamBytesUsed();
        }

        public static class Factory
        implements EvalOperator.ExpressionEvaluator.Factory {
            private final Source source;
            private final EvalOperator.ExpressionEvaluator.Factory field1;
            private final EvalOperator.ExpressionEvaluator.Factory field2;

            public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
                this.source = source;
                this.field1 = field1;
                this.field2 = field2;
            }

            public MvContainsBytesRefEvaluator get(DriverContext context) {
                return new MvContainsBytesRefEvaluator(this.field1.get(context), this.field2.get(context), context);
            }

            public String toString() {
                return "MvContainsBytesRefEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
            }
        }
    }

    public static class MvContainsDoubleEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvContainsDoubleEvaluator.class);
        private final EvalOperator.ExpressionEvaluator field1;
        private final EvalOperator.ExpressionEvaluator field2;
        private final DriverContext driverContext;

        public MvContainsDoubleEvaluator(EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
            this.field1 = field1;
            this.field2 = field2;
            this.driverContext = driverContext;
        }

        public Block eval(Page page) {
            try (DoubleBlock field1Block = (DoubleBlock)this.field1.eval(page);){
                BooleanBlock booleanBlock;
                block12: {
                    DoubleBlock field2Block = (DoubleBlock)this.field2.eval(page);
                    try {
                        booleanBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                        if (field2Block == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (field2Block != null) {
                            try {
                                field2Block.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    field2Block.close();
                }
                return booleanBlock;
            }
        }

        public BooleanBlock eval(int positionCount, DoubleBlock field1Block, DoubleBlock field2Block) {
            try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    MvContains.process(result, p, field1Block, field2Block);
                }
                BooleanBlock booleanBlock = result.build();
                return booleanBlock;
            }
        }

        public String toString() {
            return "MvContainsDoubleEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
        }

        public long baseRamBytesUsed() {
            long baseRamBytesUsed = BASE_RAM_BYTES_USED;
            baseRamBytesUsed += this.field1.baseRamBytesUsed();
            return baseRamBytesUsed += this.field2.baseRamBytesUsed();
        }

        public static class Factory
        implements EvalOperator.ExpressionEvaluator.Factory {
            private final Source source;
            private final EvalOperator.ExpressionEvaluator.Factory field1;
            private final EvalOperator.ExpressionEvaluator.Factory field2;

            public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
                this.source = source;
                this.field1 = field1;
                this.field2 = field2;
            }

            public MvContainsDoubleEvaluator get(DriverContext context) {
                return new MvContainsDoubleEvaluator(this.field1.get(context), this.field2.get(context), context);
            }

            public String toString() {
                return "MvContainsDoubleEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
            }
        }
    }

    public static class MvContainsIntEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvContainsIntEvaluator.class);
        private final EvalOperator.ExpressionEvaluator field1;
        private final EvalOperator.ExpressionEvaluator field2;
        private final DriverContext driverContext;

        public MvContainsIntEvaluator(EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
            this.field1 = field1;
            this.field2 = field2;
            this.driverContext = driverContext;
        }

        public Block eval(Page page) {
            try (IntBlock field1Block = (IntBlock)this.field1.eval(page);){
                BooleanBlock booleanBlock;
                block12: {
                    IntBlock field2Block = (IntBlock)this.field2.eval(page);
                    try {
                        booleanBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                        if (field2Block == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (field2Block != null) {
                            try {
                                field2Block.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    field2Block.close();
                }
                return booleanBlock;
            }
        }

        public BooleanBlock eval(int positionCount, IntBlock field1Block, IntBlock field2Block) {
            try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    MvContains.process(result, p, field1Block, field2Block);
                }
                BooleanBlock booleanBlock = result.build();
                return booleanBlock;
            }
        }

        public String toString() {
            return "MvContainsIntEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
        }

        public long baseRamBytesUsed() {
            long baseRamBytesUsed = BASE_RAM_BYTES_USED;
            baseRamBytesUsed += this.field1.baseRamBytesUsed();
            return baseRamBytesUsed += this.field2.baseRamBytesUsed();
        }

        public static class Factory
        implements EvalOperator.ExpressionEvaluator.Factory {
            private final Source source;
            private final EvalOperator.ExpressionEvaluator.Factory field1;
            private final EvalOperator.ExpressionEvaluator.Factory field2;

            public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
                this.source = source;
                this.field1 = field1;
                this.field2 = field2;
            }

            public MvContainsIntEvaluator get(DriverContext context) {
                return new MvContainsIntEvaluator(this.field1.get(context), this.field2.get(context), context);
            }

            public String toString() {
                return "MvContainsIntEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
            }
        }
    }

    public static class MvContainsLongEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvContainsLongEvaluator.class);
        private final EvalOperator.ExpressionEvaluator field1;
        private final EvalOperator.ExpressionEvaluator field2;
        private final DriverContext driverContext;

        public MvContainsLongEvaluator(EvalOperator.ExpressionEvaluator field1, EvalOperator.ExpressionEvaluator field2, DriverContext driverContext) {
            this.field1 = field1;
            this.field2 = field2;
            this.driverContext = driverContext;
        }

        public Block eval(Page page) {
            try (LongBlock field1Block = (LongBlock)this.field1.eval(page);){
                BooleanBlock booleanBlock;
                block12: {
                    LongBlock field2Block = (LongBlock)this.field2.eval(page);
                    try {
                        booleanBlock = this.eval(page.getPositionCount(), field1Block, field2Block);
                        if (field2Block == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (field2Block != null) {
                            try {
                                field2Block.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    field2Block.close();
                }
                return booleanBlock;
            }
        }

        public BooleanBlock eval(int positionCount, LongBlock field1Block, LongBlock field2Block) {
            try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
                for (int p = 0; p < positionCount; ++p) {
                    MvContains.process(result, p, field1Block, field2Block);
                }
                BooleanBlock booleanBlock = result.build();
                return booleanBlock;
            }
        }

        public String toString() {
            return "MvContainsLongEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field1, this.field2});
        }

        public long baseRamBytesUsed() {
            long baseRamBytesUsed = BASE_RAM_BYTES_USED;
            baseRamBytesUsed += this.field1.baseRamBytesUsed();
            return baseRamBytesUsed += this.field2.baseRamBytesUsed();
        }

        public static class Factory
        implements EvalOperator.ExpressionEvaluator.Factory {
            private final Source source;
            private final EvalOperator.ExpressionEvaluator.Factory field1;
            private final EvalOperator.ExpressionEvaluator.Factory field2;

            public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field1, EvalOperator.ExpressionEvaluator.Factory field2) {
                this.source = source;
                this.field1 = field1;
                this.field2 = field2;
            }

            public MvContainsLongEvaluator get(DriverContext context) {
                return new MvContainsLongEvaluator(this.field1.get(context), this.field2.get(context), context);
            }

            public String toString() {
                return "MvContainsLongEvaluator[field1=" + String.valueOf(this.field1) + ", field2=" + String.valueOf(this.field2) + "]";
            }
        }
    }

    static interface ValueExtractor<BlockType extends Block, Type> {
        public Type extractValue(BlockType var1, int var2);
    }

    public static final class ConstantBooleanTrueEvaluator
    implements EvalOperator.ExpressionEvaluator.Factory {
        public EvalOperator.ExpressionEvaluator get(final DriverContext driverContext) {
            return new EvalOperator.ExpressionEvaluator(){

                public Block eval(Page page) {
                    return driverContext.blockFactory().newConstantBooleanBlockWith(true, page.getPositionCount());
                }

                public void close() {
                }

                public String toString() {
                    return "ConstantBooleanTrueEvaluator";
                }

                public long baseRamBytesUsed() {
                    return 0L;
                }
            };
        }

        public String toString() {
            return "ConstantBooleanTrueEvaluator";
        }
    }
}

