/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeohashFromStringEvaluator;

public class ToGeohash
extends AbstractConvertFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToGeohash", ToGeohash::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.GEOHASH, (source, fieldEval) -> fieldEval), Map.entry(DataType.LONG, (source, fieldEval) -> fieldEval), Map.entry(DataType.KEYWORD, ToGeohashFromStringEvaluator.Factory::new), Map.entry(DataType.TEXT, ToGeohashFromStringEvaluator.Factory::new));

    @FunctionInfo(returnType={"geohash"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Converts an input value to a `geohash` value.\nA string will only be successfully converted if it respects the\n`geohash` format, as described for the\n[geohash grid aggregation](/reference/aggregations/search-aggregations-bucket-geohashgrid-aggregation.md).", examples={@Example(file="spatial-grid", tag="to_geohash")})
    public ToGeohash(Source source, @Param(name="field", type={"geohash", "long", "keyword", "text"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression field) {
        super(source, field);
    }

    private ToGeohash(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToGeohash.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.GEOHASH;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToGeohash(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToGeohash::new, (Object)this.field());
    }

    static long fromString(BytesRef in) {
        return Geohash.longEncode((String)in.utf8ToString());
    }
}

