/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.RequestDispatcher;
import org.elasticsearch.action.fieldcaps.TransportFieldCapabilitiesAction;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.action.EsqlResolveFieldsResponse;

public class EsqlResolveFieldsAction
extends HandledTransportAction<FieldCapabilitiesRequest, EsqlResolveFieldsResponse> {
    public static final String NAME = "indices:data/read/esql/resolve_fields";
    public static final ActionType<EsqlResolveFieldsResponse> TYPE = new ActionType("indices:data/read/esql/resolve_fields");
    public static final RemoteClusterActionType<FieldCapabilitiesResponse> RESOLVE_REMOTE_TYPE = new RemoteClusterActionType("indices:data/read/esql/resolve_fields", FieldCapabilitiesResponse::new);
    private static final Logger LOGGER = LogManager.getLogger(EsqlResolveFieldsAction.class);
    private final Executor searchCoordinationExecutor;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndicesService indicesService;
    private final boolean ccsCheckCompatibility;
    private final ThreadPool threadPool;
    private final TimeValue forceConnectTimeoutSecs;

    @Inject
    public EsqlResolveFieldsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndicesService indicesService, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(NAME, transportService, actionFilters, FieldCapabilitiesRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.searchCoordinationExecutor = threadPool.executor("search_coordination");
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.projectResolver = projectResolver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indicesService = indicesService;
        this.ccsCheckCompatibility = (Boolean)SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        this.threadPool = threadPool;
        this.forceConnectTimeoutSecs = clusterService.getSettings().getAsTime("search.ccs.force_connect_timeout", null);
    }

    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<EsqlResolveFieldsResponse> listener) {
        this.executeRequest(task, request, listener);
    }

    public void executeRequest(Task task, FieldCapabilitiesRequest request, ActionListener<EsqlResolveFieldsResponse> listener) {
        this.searchCoordinationExecutor.execute((Runnable)ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, (ActionListener<EsqlResolveFieldsResponse>)l)));
    }

    private void doExecuteForked(Task task, FieldCapabilitiesRequest request, ActionListener<EsqlResolveFieldsResponse> listener) {
        if (request.isMergeResults()) {
            throw new IllegalArgumentException("merging results not supported");
        }
        if (this.ccsCheckCompatibility) {
            TransportSearchHelper.checkCCSVersionCompatibility((Writeable)request);
        }
        Executor singleThreadedExecutor = TransportFieldCapabilitiesAction.buildSingleThreadedExecutor((Executor)this.searchCoordinationExecutor, (Logger)LOGGER);
        assert (task instanceof CancellableTask);
        CancellableTask fieldCapTask = (CancellableTask)task;
        long nowInMillis = request.nowInMillis() == null ? System.currentTimeMillis() : request.nowInMillis();
        ClusterState clusterState = this.clusterService.state();
        ProjectState projectState = this.projectResolver.getProjectState(clusterState);
        AtomicReference<TransportVersion> minTransportVersion = new AtomicReference<TransportVersion>(clusterState.getMinTransportVersion());
        Map remoteClusterIndices = this.transportService.getRemoteClusterService().groupIndices(request.indicesOptions(), request.indices(), request.returnLocalAll());
        OriginalIndices localIndices = (OriginalIndices)remoteClusterIndices.remove("");
        String[] concreteIndices = localIndices == null ? Strings.EMPTY_ARRAY : this.indexNameExpressionResolver.concreteIndexNames(projectState.metadata(), (IndicesRequest)localIndices);
        if (concreteIndices.length == 0 && remoteClusterIndices.isEmpty()) {
            listener.onResponse((Object)new EsqlResolveFieldsResponse(new FieldCapabilitiesResponse(new String[0], Collections.emptyMap()), minTransportVersion.get()));
            return;
        }
        TransportFieldCapabilitiesAction.checkIndexBlocks((ProjectState)projectState, (String[])concreteIndices);
        TransportFieldCapabilitiesAction.FailureCollector indexFailures = new TransportFieldCapabilitiesAction.FailureCollector();
        HashMap indexResponses = new HashMap();
        HashMap indexMappingHashToResponses = new HashMap();
        Runnable releaseResourcesOnCancel = () -> {
            LOGGER.trace("clear index responses on cancellation");
            indexFailures.clear();
            indexResponses.clear();
            indexMappingHashToResponses.clear();
        };
        Consumer<FieldCapabilitiesIndexResponse> handleIndexResponse = resp -> {
            FieldCapabilitiesIndexResponse curr;
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
                return;
            }
            if (resp.canMatch() && resp.getIndexMappingHash() != null && (curr = indexMappingHashToResponses.putIfAbsent(resp.getIndexMappingHash(), resp)) != null) {
                resp = new FieldCapabilitiesIndexResponse(resp.getIndexName(), curr.getIndexMappingHash(), curr.get(), true, curr.getIndexMode());
            }
            if (request.includeEmptyFields()) {
                indexResponses.putIfAbsent(resp.getIndexName(), resp);
            } else {
                indexResponses.merge(resp.getIndexName(), resp, (a, b) -> {
                    if (a.get().equals(b.get())) {
                        return a;
                    }
                    HashMap mergedCaps = new HashMap(a.get());
                    mergedCaps.putAll(b.get());
                    return new FieldCapabilitiesIndexResponse(a.getIndexName(), a.getIndexMappingHash(), mergedCaps, true, a.getIndexMode());
                });
            }
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
            }
        };
        BiConsumer<String, Exception> handleIndexFailure = (index, error) -> {
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
                return;
            }
            indexFailures.collect(index, error);
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
            }
        };
        AtomicBoolean finishedOrCancelled = new AtomicBoolean();
        fieldCapTask.addListener(() -> {
            if (finishedOrCancelled.compareAndSet(false, true)) {
                singleThreadedExecutor.execute(releaseResourcesOnCancel);
                LOGGER.trace("clear index responses on cancellation submitted");
            }
        });
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            finishedOrCancelled.set(true);
            if (fieldCapTask.notifyIfCancelled(listener)) {
                releaseResourcesOnCancel.run();
            } else {
                EsqlResolveFieldsAction.finishHim(indexResponses, indexFailures, (ActionListener<FieldCapabilitiesResponse>)listener.map(caps -> new EsqlResolveFieldsResponse((FieldCapabilitiesResponse)caps, (TransportVersion)minTransportVersion.get())));
            }
        });){
            RequestDispatcher requestDispatcher = new RequestDispatcher(this.clusterService, this.transportService, this.projectResolver, this.indicesService.getCoordinatorRewriteContextProvider(() -> nowInMillis), task, request, localIndices, nowInMillis, concreteIndices, singleThreadedExecutor, handleIndexResponse, handleIndexFailure, () -> ((Releasable)refs.acquire()).close());
            requestDispatcher.execute();
            for (Map.Entry remoteIndices : remoteClusterIndices.entrySet()) {
                String clusterAlias = (String)remoteIndices.getKey();
                OriginalIndices originalIndices = (OriginalIndices)remoteIndices.getValue();
                FieldCapabilitiesRequest remoteRequest = TransportFieldCapabilitiesAction.prepareRemoteRequest((String)clusterAlias, (FieldCapabilitiesRequest)request, (OriginalIndices)originalIndices, (long)nowInMillis);
                ActionListener remoteListener = ActionListener.wrap(response -> {
                    for (FieldCapabilitiesIndexResponse resp : response.caps().getIndexResponses()) {
                        String indexName = RemoteClusterAware.buildRemoteIndexName((String)clusterAlias, (String)resp.getIndexName());
                        handleIndexResponse.accept(new FieldCapabilitiesIndexResponse(indexName, resp.getIndexMappingHash(), resp.get(), resp.canMatch(), resp.getIndexMode()));
                    }
                    for (FieldCapabilitiesFailure failure : response.caps().getFailures()) {
                        Exception ex = failure.getException();
                        for (String index : failure.getIndices()) {
                            handleIndexFailure.accept(RemoteClusterAware.buildRemoteIndexName((String)clusterAlias, (String)index), ex);
                        }
                    }
                    minTransportVersion.accumulateAndGet(response.minTransportVersion(), (lhs, rhs) -> {
                        if (lhs == null || rhs == null) {
                            return null;
                        }
                        return TransportVersion.min((TransportVersion)lhs, (TransportVersion)rhs);
                    });
                }, ex -> {
                    for (String index : originalIndices.indices()) {
                        handleIndexFailure.accept(RemoteClusterAware.buildRemoteIndexName((String)clusterAlias, (String)index), (Exception)ex);
                    }
                });
                SubscribableListener connectionListener = new SubscribableListener();
                if (this.forceConnectTimeoutSecs != null) {
                    connectionListener.addTimeout(this.forceConnectTimeoutSecs, this.threadPool, singleThreadedExecutor);
                }
                connectionListener.addListener(new TransportFieldCapabilitiesAction.ForkingOnFailureActionListener(singleThreadedExecutor, true, ActionListener.releaseAfter((ActionListener)remoteListener, (Releasable)refs.acquire())).delegateFailure((responseListener, conn) -> this.transportService.sendRequest(conn, RESOLVE_REMOTE_TYPE.name(), (TransportRequest)remoteRequest, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(responseListener, EsqlResolveFieldsResponse::new, singleThreadedExecutor))));
                boolean ensureConnected = this.forceConnectTimeoutSecs != null || this.transportService.getRemoteClusterService().isSkipUnavailable(clusterAlias).orElse(true) == false;
                this.transportService.getRemoteClusterService().maybeEnsureConnectedAndGetConnection(clusterAlias, ensureConnected, (ActionListener)connectionListener);
            }
        }
    }

    private static void finishHim(Map<String, FieldCapabilitiesIndexResponse> indexResponses, TransportFieldCapabilitiesAction.FailureCollector indexFailures, ActionListener<FieldCapabilitiesResponse> listener) {
        List failures = indexFailures.build(indexResponses.keySet());
        if (!indexResponses.isEmpty()) {
            listener.onResponse((Object)new FieldCapabilitiesResponse(new ArrayList<FieldCapabilitiesIndexResponse>(indexResponses.values()), failures));
        } else if (!indexFailures.isEmpty()) {
            if (failures.stream().anyMatch(failure -> {
                IllegalStateException ise;
                Exception patt0$temp = failure.getException();
                return patt0$temp instanceof IllegalStateException && (ise = (IllegalStateException)patt0$temp).getCause() instanceof ElasticsearchTimeoutException;
            })) {
                listener.onResponse((Object)new FieldCapabilitiesResponse(Collections.emptyList(), failures));
            } else {
                listener.onFailure(((FieldCapabilitiesFailure)failures.get(0)).getException());
            }
        } else {
            listener.onResponse((Object)new FieldCapabilitiesResponse(Collections.emptyList(), Collections.emptyList()));
        }
    }
}

