/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ParserConstructor;
import org.elasticsearch.xcontent.XContentParser;

public class InstantiatingObjectParser<Value, Context>
implements BiFunction<XContentParser, Context, Value>,
ContextParser<Context, Value> {
    private final ConstructingObjectParser<Value, Context> constructingObjectParser;

    public static <Value, Context> Builder<Value, Context> builder(String name, boolean ignoreUnknownFields, Class<Value> valueClass) {
        return new Builder(name, ignoreUnknownFields, valueClass);
    }

    public static <Value, Context> Builder<Value, Context> builder(String name, Class<Value> valueClass) {
        return new Builder(name, valueClass);
    }

    private InstantiatingObjectParser(ConstructingObjectParser<Value, Context> constructingObjectParser) {
        this.constructingObjectParser = constructingObjectParser;
    }

    @Override
    public Value parse(XContentParser parser, Context context) throws IOException {
        return this.constructingObjectParser.parse(parser, context);
    }

    @Override
    public Value apply(XContentParser xContentParser, Context context) {
        return this.constructingObjectParser.apply(xContentParser, context);
    }

    public static class Builder<Value, Context>
    extends AbstractObjectParser<Value, Context> {
        private final ConstructingObjectParser<Value, Context> constructingObjectParser;
        private final Class<Value> valueClass;
        private Constructor<Value> constructor;

        public Builder(String name, Class<Value> valueClass) {
            this(name, false, valueClass);
        }

        public Builder(String name, boolean ignoreUnknownFields, Class<Value> valueClass) {
            this.constructingObjectParser = new ConstructingObjectParser<Object, Object>(name, ignoreUnknownFields, this::buildInstance);
            this.valueClass = valueClass;
        }

        public InstantiatingObjectParser<Value, Context> build() {
            Constructor<?> constructor = null;
            int neededArguments = this.constructingObjectParser.getNumberOfFields();
            for (Constructor<?> c : this.valueClass.getConstructors()) {
                if (c.getAnnotation(ParserConstructor.class) == null) continue;
                if (constructor != null) {
                    throw new IllegalArgumentException("More then one public constructor with @ParserConstructor annotation exist in the class " + this.valueClass.getName());
                }
                if (c.getParameterCount() < neededArguments || c.getParameterCount() > neededArguments + 1) {
                    throw new IllegalArgumentException("Annotated constructor doesn't have " + neededArguments + " or " + (neededArguments + 1) + " arguments in the class " + this.valueClass.getName());
                }
                constructor = c;
            }
            if (constructor == null) {
                for (Constructor<?> c : this.valueClass.getConstructors()) {
                    if (c.getParameterCount() != neededArguments) continue;
                    if (constructor != null) {
                        throw new IllegalArgumentException("More then one public constructor with " + neededArguments + " arguments found. The use of @ParserConstructor annotation is required for class " + this.valueClass.getName());
                    }
                    constructor = c;
                }
            }
            if (constructor == null) {
                throw new IllegalArgumentException("No public constructors with " + neededArguments + " parameters exist in the class " + this.valueClass.getName());
            }
            this.constructor = constructor;
            return new InstantiatingObjectParser<Value, Context>(this.constructingObjectParser);
        }

        @Override
        public <T> void declareField(BiConsumer<Value, T> consumer, ContextParser<Context, T> parser, ParseField parseField, ObjectParser.ValueType type) {
            this.constructingObjectParser.declareField(consumer, parser, parseField, type);
        }

        @Override
        public <T> void declareNamedObject(BiConsumer<Value, T> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, ParseField parseField) {
            this.constructingObjectParser.declareNamedObject(consumer, namedObjectParser, parseField);
        }

        @Override
        public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, ParseField parseField) {
            this.constructingObjectParser.declareNamedObjects(consumer, namedObjectParser, parseField);
        }

        @Override
        public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, Consumer<Value> orderedModeCallback, ParseField parseField) {
            this.constructingObjectParser.declareNamedObjects(consumer, namedObjectParser, orderedModeCallback, parseField);
        }

        @Override
        public String getName() {
            return this.constructingObjectParser.getName();
        }

        @Override
        public void declareRequiredFieldSet(String ... requiredSet) {
            this.constructingObjectParser.declareRequiredFieldSet(requiredSet);
        }

        @Override
        public void declareExclusiveFieldSet(String ... exclusiveSet) {
            this.constructingObjectParser.declareExclusiveFieldSet(exclusiveSet);
        }

        private Value buildInstance(Object[] args, Context context) {
            if (this.constructor == null) {
                throw new IllegalArgumentException("InstantiatingObjectParser for type " + this.valueClass.getName() + " has to be finalized before the first use");
            }
            try {
                if (this.constructor.getParameterCount() != args.length) {
                    Object[] newArgs = new Object[args.length + 1];
                    System.arraycopy(args, 0, newArgs, 1, args.length);
                    newArgs[0] = context;
                    return this.constructor.newInstance(newArgs);
                }
                return this.constructor.newInstance(args);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot instantiate an object of " + this.valueClass.getName(), ex);
            }
        }
    }
}

