/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.datapoint;

import io.opentelemetry.proto.common.v1.KeyValue;
import java.util.List;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.core.Nullable;

public final class TargetIndex {
    public static final String TYPE_METRICS = "metrics";
    private static final String ELASTICSEARCH_INDEX = "elasticsearch.index";
    private static final String DATA_STREAM_DATASET = "data_stream.dataset";
    private static final String DATA_STREAM_NAMESPACE = "data_stream.namespace";
    private static final String DEFAULT_DATASET = "generic";
    private static final String OTEL_DATASET_SUFFIX = ".otel";
    private static final String DEFAULT_NAMESPACE = "default";
    private static final TargetIndex DEFAULT_METRICS_TARGET = TargetIndex.evaluate("metrics", List.of(), null, List.of(), List.of());
    private String index;
    private String type;
    private String dataset;
    private String namespace;

    public static TargetIndex defaultMetrics() {
        return DEFAULT_METRICS_TARGET;
    }

    public static boolean isTargetIndexAttribute(String attributeKey) {
        return attributeKey.equals(ELASTICSEARCH_INDEX) || attributeKey.equals(DATA_STREAM_DATASET) || attributeKey.equals(DATA_STREAM_NAMESPACE);
    }

    public static TargetIndex evaluate(String type, List<KeyValue> attributes, @Nullable String receiverName, List<KeyValue> scopeAttributes, List<KeyValue> resourceAttributes) {
        TargetIndex target = new TargetIndex();
        target.populateFrom(attributes);
        target.populateFrom(scopeAttributes);
        target.populateFrom(resourceAttributes);
        if (target.index == null) {
            target.type = type;
            if (target.dataset == null && receiverName != null) {
                target.dataset = receiverName;
            }
            target.dataset = DataStream.sanitizeDataset((String)target.dataset);
            if (target.dataset == null) {
                target.dataset = DEFAULT_DATASET;
            }
            target.dataset = target.dataset + OTEL_DATASET_SUFFIX;
            target.namespace = DataStream.sanitizeNamespace((String)target.namespace);
            if (target.namespace == null) {
                target.namespace = DEFAULT_NAMESPACE;
            }
            target.index = target.type + "-" + target.dataset + "-" + target.namespace;
        } else {
            target.type = null;
            target.dataset = null;
            target.namespace = null;
        }
        return target;
    }

    private TargetIndex() {
    }

    private void populateFrom(List<KeyValue> attributes) {
        if (this.isPopulated()) {
            return;
        }
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            KeyValue attr = attributes.get(i);
            if (attr.getKey().equals(ELASTICSEARCH_INDEX)) {
                this.index = attr.getValue().getStringValue();
                continue;
            }
            if (this.dataset == null && attr.getKey().equals(DATA_STREAM_DATASET)) {
                this.dataset = attr.getValue().getStringValue();
                continue;
            }
            if (this.namespace != null || !attr.getKey().equals(DATA_STREAM_NAMESPACE)) continue;
            this.namespace = attr.getValue().getStringValue();
        }
    }

    private boolean isPopulated() {
        return this.dataset != null && this.namespace != null || this.index != null;
    }

    public boolean isDataStream() {
        return this.type != null && this.dataset != null && this.namespace != null;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String dataset() {
        return this.dataset;
    }

    public String namespace() {
        return this.namespace;
    }

    public String toString() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetIndex that = (TargetIndex)o;
        return this.index.equals(that.index);
    }

    public int hashCode() {
        return this.index.hashCode();
    }
}

